/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Matrix;
import android.graphics.PointF;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.ScaleXY;

class TransformKeyframeAnimation {
    private final Matrix matrix = new Matrix();
    private final BaseKeyframeAnimation<?, PointF> anchorPoint;
    private final BaseKeyframeAnimation<?, PointF> position;
    private final BaseKeyframeAnimation<?, ScaleXY> scale;
    private final BaseKeyframeAnimation<?, Float> rotation;
    private final BaseKeyframeAnimation<?, Integer> opacity;

    TransformKeyframeAnimation(AnimatableTransform animatableTransform) {
        this.anchorPoint = animatableTransform.getAnchorPoint().createAnimation();
        this.position = animatableTransform.getPosition().createAnimation();
        this.scale = animatableTransform.getScale().createAnimation();
        this.rotation = animatableTransform.getRotation().createAnimation();
        this.opacity = animatableTransform.getOpacity().createAnimation();
    }

    void addAnimationsToLayer(BaseLayer layer) {
        layer.addAnimation(this.anchorPoint);
        layer.addAnimation(this.position);
        layer.addAnimation(this.scale);
        layer.addAnimation(this.rotation);
        layer.addAnimation(this.opacity);
    }

    void addListener(BaseKeyframeAnimation.AnimationListener listener) {
        this.anchorPoint.addUpdateListener(listener);
        this.position.addUpdateListener(listener);
        this.scale.addUpdateListener(listener);
        this.rotation.addUpdateListener(listener);
        this.opacity.addUpdateListener(listener);
    }

    BaseKeyframeAnimation<?, Integer> getOpacity() {
        return this.opacity;
    }

    Matrix getMatrix() {
        ScaleXY scaleTransform;
        float rotation;
        this.matrix.reset();
        PointF position = this.position.getValue();
        if (position.x != 0.0f || position.y != 0.0f) {
            this.matrix.preTranslate(position.x, position.y);
        }
        if ((rotation = this.rotation.getValue().floatValue()) != 0.0f) {
            this.matrix.preRotate(rotation);
        }
        if ((scaleTransform = this.scale.getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f) {
            this.matrix.preScale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        PointF anchorPoint = this.anchorPoint.getValue();
        if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
            this.matrix.preTranslate(-anchorPoint.x, -anchorPoint.y);
        }
        return this.matrix;
    }
}

