/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.RestrictTo;
import android.support.v4.os.TraceCompat;
import android.util.Log;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class L {
    public static final String TAG = "LOTTIE";
    public static final boolean DBG = false;
    private static final int MAX_DEPTH = 20;
    private static boolean traceEnabled = false;
    private static String[] sections;
    private static long[] startTimeNs;
    private static int traceDepth;
    private static int depthPastMaxDepth;

    public static void warn(String msg) {
        Log.w((String)TAG, (String)msg);
    }

    public static void setTraceEnabled(boolean enabled) {
        if (traceEnabled == enabled) {
            return;
        }
        traceEnabled = enabled;
        if (traceEnabled) {
            sections = new String[20];
            startTimeNs = new long[20];
        }
    }

    public static void beginSection(String section) {
        if (!traceEnabled) {
            return;
        }
        if (traceDepth == 20) {
            ++depthPastMaxDepth;
            return;
        }
        L.sections[L.traceDepth] = section;
        L.startTimeNs[L.traceDepth] = System.nanoTime();
        TraceCompat.beginSection((String)section);
        ++traceDepth;
    }

    public static float endSection(String section) {
        if (depthPastMaxDepth > 0) {
            --depthPastMaxDepth;
            return 0.0f;
        }
        if (!traceEnabled) {
            return 0.0f;
        }
        if (--traceDepth == -1) {
            throw new IllegalStateException("Can't end trace section. There are none.");
        }
        if (!section.equals(sections[traceDepth])) {
            throw new IllegalStateException("Unbalanced trace call " + section + ". Expected " + sections[traceDepth] + ".");
        }
        TraceCompat.endSection();
        return (float)(System.nanoTime() - startTimeNs[traceDepth]) / 1000000.0f;
    }

    static {
        traceDepth = 0;
        depthPastMaxDepth = 0;
    }
}

