/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatableSplitDimensionPathValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.KeyframesParser;
import com.airbnb.lottie.parser.PathKeyframeParser;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.ArrayList;

public class AnimatablePathValueParser {
    private AnimatablePathValueParser() {
    }

    public static AnimatablePathValue parse(JsonReader reader, LottieComposition composition) throws IOException {
        ArrayList<Keyframe<PointF>> keyframes = new ArrayList<Keyframe<PointF>>();
        if (reader.peek() == JsonToken.BEGIN_ARRAY) {
            reader.beginArray();
            while (reader.hasNext()) {
                keyframes.add(PathKeyframeParser.parse(reader, composition));
            }
            reader.endArray();
            KeyframesParser.setEndFrames(keyframes);
        } else {
            keyframes.add(new Keyframe<PointF>(JsonUtils.jsonToPoint(reader, Utils.dpScale())));
        }
        return new AnimatablePathValue(keyframes);
    }

    static AnimatableValue<PointF, PointF> parseSplitPath(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatablePathValue pathAnimation = null;
        AnimatableFloatValue xAnimation = null;
        AnimatableFloatValue yAnimation = null;
        boolean hasExpressions = false;
        reader.beginObject();
        block10: while (reader.peek() != JsonToken.END_OBJECT) {
            switch (reader.nextName()) {
                case "k": {
                    pathAnimation = AnimatablePathValueParser.parse(reader, composition);
                    continue block10;
                }
                case "x": {
                    if (reader.peek() == JsonToken.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block10;
                    }
                    xAnimation = AnimatableValueParser.parseFloat(reader, composition);
                    continue block10;
                }
                case "y": {
                    if (reader.peek() == JsonToken.STRING) {
                        hasExpressions = true;
                        reader.skipValue();
                        continue block10;
                    }
                    yAnimation = AnimatableValueParser.parseFloat(reader, composition);
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        if (hasExpressions) {
            composition.addWarning("Lottie doesn't support expressions.");
        }
        if (pathAnimation != null) {
            return pathAnimation;
        }
        return new AnimatableSplitDimensionPathValue(xAnimation, yAnimation);
    }
}

