/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.RectangleShape;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class RectangleShapeParser {
    private static JsonReader.Options NAMES = JsonReader.Options.of("nm", "p", "s", "r", "hd");

    private RectangleShapeParser() {
    }

    static RectangleShape parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatablePointValue size = null;
        AnimatableFloatValue roundedness = null;
        boolean hidden = false;
        block7: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block7;
                }
                case 1: {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block7;
                }
                case 2: {
                    size = AnimatableValueParser.parsePoint(reader, composition);
                    continue block7;
                }
                case 3: {
                    roundedness = AnimatableValueParser.parseFloat(reader, composition);
                    continue block7;
                }
                case 4: {
                    hidden = reader.nextBoolean();
                    continue block7;
                }
            }
            reader.skipValue();
        }
        return new RectangleShape(name, position, size, roundedness, hidden);
    }
}

