/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import com.airbnb.deeplinkdispatch.DeepLinkEntry;
import com.airbnb.deeplinkdispatch.DeepLinkUri;
import com.airbnb.deeplinkdispatch.Host;
import com.airbnb.deeplinkdispatch.MatchType;
import com.airbnb.deeplinkdispatch.NodeMetadata;
import com.airbnb.deeplinkdispatch.PathSegment;
import com.airbnb.deeplinkdispatch.Scheme;
import com.airbnb.deeplinkdispatch.TreeNode;
import com.airbnb.deeplinkdispatch.UriMatch;
import com.airbnb.deeplinkdispatch.UrlTreeKt;
import com.airbnb.deeplinkdispatch.base.Utils;
import com.airbnb.deeplinkdispatch.base.UtilsKt;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lcom/airbnb/deeplinkdispatch/Root;", "Lcom/airbnb/deeplinkdispatch/TreeNode;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "addToTrie", "", "deepLinkEntry", "Lcom/airbnb/deeplinkdispatch/DeepLinkEntry;", "component1", "copy", "equals", "", "other", "", "getStrings", "", "", "hashCode", "", "toString", "uriMatch", "Lcom/airbnb/deeplinkdispatch/UriMatch;", "writeToOutoutStream", "openOutputStream", "Ljava/io/OutputStream;", "deeplinkdispatch-base"})
public final class Root
extends TreeNode {
    @NotNull
    private final String id;

    public Root(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super("r", new NodeMetadata(1, id));
        this.id = id;
    }

    public /* synthetic */ Root(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "r";
        }
        this(string);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    public final void writeToOutoutStream(@NotNull OutputStream openOutputStream) {
        Intrinsics.checkNotNullParameter((Object)openOutputStream, (String)"openOutputStream");
        byte[] byArray = this.toUByteArray-TcUX1vc();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
        openOutputStream.write(byArray2);
    }

    @NotNull
    public final List<CharSequence> getStrings() {
        byte[] byArray = this.toUByteArray-TcUX1vc();
        Object object = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"copyOf(this, size)");
        byte[] byArray2 = object;
        object = Charset.forName("ISO_8859_1");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(MATCH_INDEX_ENCODING)");
        return UtilsKt.chunkOnModifiedUtf8ByteSize(new String(byArray2, (Charset)object), 65535);
    }

    /*
     * WARNING - void declaration
     */
    public final void addToTrie(@NotNull DeepLinkEntry deepLinkEntry) {
        Iterator<String> it;
        Intrinsics.checkNotNullParameter((Object)deepLinkEntry, (String)"deepLinkEntry");
        DeepLinkUri deepLinkUri = DeepLinkUri.parseTemplate(deepLinkEntry.getUriTemplate());
        Object object = deepLinkUri.scheme();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deepLinkUri.scheme()");
        object = UrlTreeKt.orderPlaceholderValues((String)object);
        String string = object;
        TreeNode treeNode = this;
        boolean bl = false;
        Utils.INSTANCE.validateIfComponentParam((String)((Object)it));
        String string2 = object;
        TreeNode node = treeNode.addNode(new Scheme(string2));
        object = deepLinkUri.host();
        if (!(object == null || object.length() == 0)) {
            object = deepLinkUri.host();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deepLinkUri.host()");
            object = UrlTreeKt.orderPlaceholderValues((String)object);
            it = object;
            treeNode = node;
            boolean bl2 = false;
            Utils.INSTANCE.validateIfComponentParam((String)((Object)it));
            Iterator<String> iterator = object;
            node = treeNode.addNode(new Host((String)((Object)iterator)));
            object = deepLinkUri.pathSegments();
            if (object == null || object.isEmpty()) {
                node.setMatch(this.uriMatch(deepLinkEntry));
            }
        }
        if (!((object = (Collection)deepLinkUri.pathSegments()) == null || object.isEmpty())) {
            for (String pathSegment : deepLinkUri.pathSegments()) {
                void it2;
                String string3;
                Intrinsics.checkNotNullExpressionValue((Object)pathSegment, (String)"pathSegment");
                String string4 = string3 = UrlTreeKt.orderPlaceholderValues(pathSegment);
                treeNode = node;
                boolean bl3 = false;
                Utils.INSTANCE.validateIfComponentParam((String)it2);
                Utils.INSTANCE.validateIfConfigurablePathSegment((String)it2);
                String string5 = string3;
                node = treeNode.addNode(new PathSegment(string5));
            }
            node.setMatch(this.uriMatch(deepLinkEntry));
        }
    }

    private final UriMatch uriMatch(DeepLinkEntry deepLinkEntry) {
        UriMatch uriMatch;
        DeepLinkEntry deepLinkEntry2 = deepLinkEntry;
        if (deepLinkEntry2 instanceof DeepLinkEntry.ActivityDeeplinkEntry) {
            uriMatch = new UriMatch(MatchType.Activity, deepLinkEntry.getUriTemplate(), deepLinkEntry.getClassName(), null);
        } else if (deepLinkEntry2 instanceof DeepLinkEntry.MethodDeeplinkEntry) {
            uriMatch = new UriMatch(MatchType.Method, deepLinkEntry.getUriTemplate(), deepLinkEntry.getClassName(), ((DeepLinkEntry.MethodDeeplinkEntry)deepLinkEntry).getMethod());
        } else if (deepLinkEntry2 instanceof DeepLinkEntry.HandlerDeepLinkEntry) {
            uriMatch = new UriMatch(MatchType.Handler, deepLinkEntry.getUriTemplate(), deepLinkEntry.getClassName(), null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uriMatch;
    }

    @NotNull
    public final String component1() {
        return this.getId();
    }

    @NotNull
    public final Root copy(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new Root(id);
    }

    public static /* synthetic */ Root copy$default(Root root, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = root.getId();
        }
        return root.copy(string);
    }

    @NotNull
    public String toString() {
        return "Root(id=" + this.getId() + ')';
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Root)) {
            return false;
        }
        Root root = (Root)other;
        return Intrinsics.areEqual((Object)this.getId(), (Object)root.getId());
    }

    public Root() {
        this(null, 1, null);
    }
}

