/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch.base;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.deeplinkdispatch.DeepLinkEntry;
import com.airbnb.deeplinkdispatch.DeepLinkMatchResult;
import com.airbnb.deeplinkdispatch.DeepLinkUri;
import com.airbnb.deeplinkdispatch.MatchType;
import com.airbnb.deeplinkdispatch.NodeMetadata;
import com.airbnb.deeplinkdispatch.UrlElement;
import com.airbnb.deeplinkdispatch.base.CompareResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MatchIndex {
    @NonNull
    public static final String MATCH_INDEX_ENCODING = "ISO_8859_1";
    public static final int HEADER_NODE_METADATA_LENGTH = 1;
    public static final int HEADER_VALUE_LENGTH = 2;
    public static final int HEADER_MATCH_LENGTH = 2;
    public static final int HEADER_CHILDREN_LENGTH = 4;
    public static final int MATCH_DATA_URL_TEMPLATE_LENGTH = 2;
    public static final int MATCH_DATA_TYPE_LENGTH = 1;
    public static final int MATCH_DATA_CLASS_LENGTH = 2;
    public static final int MATCH_DATA_METHOD_LENGTH = 1;
    public static final int HEADER_LENGTH = 9;
    @NonNull
    public static final String ROOT_VALUE = "r";
    @NonNull
    public static final String MATCH_PARAM_DIVIDER_CHAR = String.valueOf('\u001e');
    @NonNull
    public static final char[] VARIABLE_DELIMITER = new char[]{'{', '}'};
    @NonNull
    public static final char[] ALLOWED_VALUES_DELIMITER = new char[]{'(', ')'};
    @NonNull
    public static final char ALLOWED_VALUES_SEPARATOR = '|';
    private static final String ALLOWED_VALUES_SEPARATOR_REGEX_STRING = "\\|";
    @NonNull
    public final byte[] byteArray;

    public MatchIndex(@NonNull byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public DeepLinkMatchResult matchUri(@NonNull DeepLinkUri deeplinkUri, @NonNull List<UrlElement> elements, @Nullable Map<String, String> placeholders, int elementIndex, int elementStartPosition, int parentBoundaryPos, Map<byte[], byte[]> pathSegmentReplacements) {
        DeepLinkMatchResult match = null;
        int currentElementStartPosition = elementStartPosition;
        do {
            UrlElement urlElement;
            CompareResult compareResult;
            if ((compareResult = this.compareValue(currentElementStartPosition, (urlElement = elements.get(elementIndex)).getTypeFlag(), urlElement.getValue(), pathSegmentReplacements)) != null) {
                Map<String, String> placeholdersOutput = placeholders;
                if (!compareResult.getPlaceholderValue().isEmpty()) {
                    placeholdersOutput = new HashMap<String, String>(placeholders != null ? placeholders : Collections.emptyMap());
                    String[] compareParams = compareResult.getPlaceholderValue().split(MATCH_PARAM_DIVIDER_CHAR, -1);
                    placeholdersOutput.put(compareParams[0], compareParams[1]);
                }
                if (elementIndex < elements.size() - 1 || compareResult.isEmptyConfigurablePathSegmentMatch()) {
                    int childrenPos = this.getChildrenPos(currentElementStartPosition);
                    if (childrenPos != -1) {
                        match = this.matchUri(deeplinkUri, elements, placeholdersOutput, compareResult.isEmptyConfigurablePathSegmentMatch() ? elementIndex : elementIndex + 1, childrenPos, this.getElementBoundaryPos(currentElementStartPosition), pathSegmentReplacements);
                    }
                } else {
                    int matchLength = this.getMatchLength(currentElementStartPosition);
                    if (matchLength > 0) {
                        match = this.getMatchResultFromIndex(matchLength, this.getMatchDataPos(currentElementStartPosition), deeplinkUri, placeholdersOutput);
                    }
                }
            }
            if (match == null) continue;
            return match;
        } while ((currentElementStartPosition = this.getNextElementStartPosition(currentElementStartPosition, parentBoundaryPos)) != -1);
        return null;
    }

    @NonNull
    public List<DeepLinkEntry> getAllEntries(int elementStartPos, int parentBoundaryPos) {
        ArrayList<DeepLinkEntry> resultList = new ArrayList<DeepLinkEntry>();
        int currentElementStartPosition = elementStartPos;
        do {
            int matchLength;
            if ((matchLength = this.getMatchLength(currentElementStartPosition)) > 0) {
                resultList.add(MatchIndex.getDeepLinkEntryFromIndex(this.byteArray, matchLength, this.getMatchDataPos(currentElementStartPosition)));
            }
            if (this.getChildrenPos(currentElementStartPosition) == -1) continue;
            resultList.addAll(this.getAllEntries(this.getChildrenPos(currentElementStartPosition), this.getElementBoundaryPos(currentElementStartPosition)));
        } while ((currentElementStartPosition = this.getNextElementStartPosition(currentElementStartPosition, parentBoundaryPos)) != -1);
        return resultList;
    }

    @Nullable
    public DeepLinkMatchResult getMatchResultFromIndex(int matchLength, int matchStartPosition, @NonNull DeepLinkUri deeplinkUri, @NonNull Map<String, String> placeholdersOutput) {
        DeepLinkEntry deeplinkEntry = MatchIndex.getDeepLinkEntryFromIndex(this.byteArray, matchLength, matchStartPosition);
        if (deeplinkEntry == null) {
            return null;
        }
        return new DeepLinkMatchResult(deeplinkEntry, Collections.singletonMap(deeplinkUri, placeholdersOutput));
    }

    @Nullable
    private static DeepLinkEntry getDeepLinkEntryFromIndex(@NonNull byte[] byteArray, int matchLength, int matchStartPosition) {
        if (matchLength == 0) {
            return null;
        }
        int position = matchStartPosition;
        MatchType matchType = MatchType.fromInt(MatchIndex.readOneByteAsInt(byteArray, position));
        int urlTemplateLength = MatchIndex.readTwoBytesAsInt(byteArray, ++position);
        String urlTemplate = MatchIndex.getStringFromByteArray(byteArray, position += 2, urlTemplateLength);
        int classLength = MatchIndex.readTwoBytesAsInt(byteArray, position += urlTemplateLength);
        String className = MatchIndex.getStringFromByteArray(byteArray, position += 2, classLength);
        int methodLength = MatchIndex.readOneByteAsInt(byteArray, position += classLength);
        String methodName = null;
        if (methodLength > 0) {
            methodName = MatchIndex.getStringFromByteArray(byteArray, ++position, methodLength);
        }
        switch (matchType) {
            case Activity: {
                return new DeepLinkEntry.ActivityDeeplinkEntry(urlTemplate, className);
            }
            case Method: {
                return new DeepLinkEntry.MethodDeeplinkEntry(urlTemplate, className, methodName);
            }
            case Handler: {
                return new DeepLinkEntry.HandlerDeepLinkEntry(urlTemplate, className);
            }
        }
        throw new IllegalStateException("Unhandled match type: " + matchType);
    }

    @Nullable
    private CompareResult compareValue(int elementStartPos, byte inboundUriComponentType, @NonNull byte[] inboundValue, Map<byte[], byte[]> pathSegmentReplacements) {
        boolean isValueLengthMismatch;
        int valueStartPos = elementStartPos + 9;
        NodeMetadata nodeMetadata = new NodeMetadata(this.byteArray[elementStartPos]);
        if (nodeMetadata.isComponentTypeMismatch(inboundUriComponentType)) {
            return null;
        }
        int valueLength = this.getValueLength(elementStartPos);
        boolean bl = isValueLengthMismatch = valueLength != inboundValue.length;
        if (isValueLengthMismatch && nodeMetadata.isValueLiteralValue) {
            return null;
        }
        if (nodeMetadata.isComponentParam) {
            return this.compareComponentParam(valueStartPos, valueLength, inboundValue, VARIABLE_DELIMITER);
        }
        if (nodeMetadata.isConfigurablePathSegment) {
            return this.compareConfigurablePathSegment(inboundValue, pathSegmentReplacements, valueStartPos, valueLength);
        }
        return this.arrayCompare(this.byteArray, valueStartPos, valueLength, inboundValue);
    }

    private CompareResult arrayCompare(byte[] byteArray, int startPos, int length, byte[] compareValue) {
        if (length != compareValue.length) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            if (compareValue[i] == byteArray[startPos + i]) continue;
            return null;
        }
        return new CompareResult("", false);
    }

    @Nullable
    private CompareResult compareConfigurablePathSegment(@NonNull byte[] inboundValue, Map<byte[], byte[]> pathSegmentReplacements, int valueStartPos, int valueLength) {
        byte[] replacementValue = null;
        for (Map.Entry<byte[], byte[]> pathSegmentEntry : pathSegmentReplacements.entrySet()) {
            if (this.arrayCompare(this.byteArray, valueStartPos, valueLength, pathSegmentEntry.getKey()) == null) continue;
            replacementValue = pathSegmentEntry.getValue();
        }
        if (replacementValue == null) {
            return null;
        }
        if (replacementValue.length == 0) {
            return new CompareResult("", true);
        }
        if (this.arrayCompare(inboundValue, 0, inboundValue.length, replacementValue) != null) {
            return new CompareResult("", false);
        }
        return null;
    }

    @Nullable
    private CompareResult compareComponentParam(int valueStartPos, int valueLength, @NonNull byte[] valueToMatch, char[] delimiter) {
        int valueToMatchLength = valueToMatch.length;
        if (this.byteArray[valueStartPos] == delimiter[0] && this.byteArray[valueStartPos + 1] == delimiter[1] || valueToMatchLength == 0) {
            return null;
        }
        for (int i = 0; i < valueToMatchLength; ++i) {
            boolean fullyMatchedButThereAreMoreCharsInValue;
            boolean bl = fullyMatchedButThereAreMoreCharsInValue = this.byteArray[valueStartPos + i] == valueToMatch[i] && i == valueToMatchLength - 1 && valueLength > valueToMatchLength;
            if (this.byteArray[valueStartPos + i] == delimiter[0] || fullyMatchedButThereAreMoreCharsInValue) {
                int j = valueLength - 1;
                int k = valueToMatchLength - 1;
                while (j >= 0) {
                    if (this.byteArray[valueStartPos + j] == delimiter[1]) {
                        if (fullyMatchedButThereAreMoreCharsInValue) {
                            ++i;
                        }
                        byte[] placeholderValue = new byte[k - i + 1];
                        byte[] placeholderName = new byte[valueStartPos + j - (valueStartPos + i) - 1];
                        System.arraycopy(valueToMatch, i, placeholderValue, 0, placeholderValue.length);
                        System.arraycopy(this.byteArray, valueStartPos + i + 1, placeholderName, 0, placeholderName.length);
                        int beginAllowedValues = this.verifyAllowedValues(placeholderName, placeholderValue);
                        if (beginAllowedValues > -1) {
                            byte[] placeholderValueWithoutAllowedValues = beginAllowedValues == Integer.MAX_VALUE ? placeholderName : Arrays.copyOfRange(placeholderName, 0, beginAllowedValues);
                            return new CompareResult(new String(placeholderValueWithoutAllowedValues) + MATCH_PARAM_DIVIDER_CHAR + new String(placeholderValue), false);
                        }
                        return null;
                    }
                    if (this.byteArray[valueStartPos + j] != valueToMatch[k]) {
                        return null;
                    }
                    --j;
                    --k;
                }
            }
            if (this.byteArray[valueStartPos + i] == valueToMatch[i]) continue;
            return null;
        }
        return new CompareResult("", false);
    }

    private int verifyAllowedValues(byte[] placeholderName, byte[] matchedPlaceholderValue) {
        int beginAllowedValues = this.charPos(placeholderName, ALLOWED_VALUES_DELIMITER[0]);
        if (beginAllowedValues == -1) {
            return Integer.MAX_VALUE;
        }
        int endAllowedValues = this.charPos(placeholderName, ALLOWED_VALUES_DELIMITER[1]);
        if (beginAllowedValues > endAllowedValues) {
            return Integer.MAX_VALUE;
        }
        Object[] allowedValues = new String(Arrays.copyOfRange(placeholderName, beginAllowedValues + 1, endAllowedValues)).split(ALLOWED_VALUES_SEPARATOR_REGEX_STRING);
        if (Arrays.binarySearch(allowedValues, new String(matchedPlaceholderValue)) > -1) {
            return beginAllowedValues;
        }
        return -1;
    }

    private int charPos(byte[] byteArray, char value) {
        if (byteArray == null) {
            return -1;
        }
        for (int i = 0; i < byteArray.length; ++i) {
            if (byteArray[i] != value) continue;
            return i;
        }
        return -1;
    }

    private int getNextElementStartPosition(int elementStartPos, int parentBoundaryPos) {
        int nextElementPos = this.getElementBoundaryPos(elementStartPos);
        if (nextElementPos == parentBoundaryPos) {
            return -1;
        }
        return nextElementPos;
    }

    private int getElementBoundaryPos(int elementStartPos) {
        return this.getMatchDataPos(elementStartPos) + this.getMatchLength(elementStartPos) + this.getChildrenLength(elementStartPos);
    }

    private int getChildrenPos(int elementStartPos) {
        if (this.getChildrenLength(elementStartPos) == 0) {
            return -1;
        }
        return this.getMatchDataPos(elementStartPos) + this.getMatchLength(elementStartPos);
    }

    private int getMatchDataPos(int elementStartPos) {
        return elementStartPos + 9 + this.getValueLength(elementStartPos);
    }

    private int getValueLength(int elementStartPos) {
        return MatchIndex.readTwoBytesAsInt(this.byteArray, elementStartPos + 1);
    }

    private int getMatchLength(int elementStartPos) {
        return MatchIndex.readTwoBytesAsInt(this.byteArray, elementStartPos + 1 + 2);
    }

    private int getChildrenLength(int elementStartPos) {
        return MatchIndex.readFourBytesAsInt(this.byteArray, elementStartPos + 1 + 2 + 2);
    }

    public int length() {
        return this.byteArray.length;
    }

    private static int readOneByteAsInt(byte[] byteArray, int pos) {
        return byteArray[pos] & 0xFF;
    }

    private static int readTwoBytesAsInt(byte[] byteArray, int pos) {
        return MatchIndex.readOneByteAsInt(byteArray, pos) << 8 | MatchIndex.readOneByteAsInt(byteArray, pos + 1);
    }

    private static int readFourBytesAsInt(byte[] byteArray, int pos) {
        return MatchIndex.readOneByteAsInt(byteArray, pos) << 24 | MatchIndex.readOneByteAsInt(byteArray, pos + 1) << 16 | MatchIndex.readOneByteAsInt(byteArray, pos + 2) << 8 | MatchIndex.readOneByteAsInt(byteArray, pos + 3);
    }

    @Nullable
    private static String getStringFromByteArray(byte[] byteArray, int start, int length) {
        byte[] stringByteAray = new byte[length];
        System.arraycopy(byteArray, start, stringByteAray, 0, length);
        try {
            return new String(stringByteAray, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @NonNull
    public static String getMatchIdxFileName(@NonNull String moduleName) {
        return "dld_match_" + moduleName.toLowerCase() + ".idx";
    }
}

