/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch.base;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001d\u0010\u000b\u001a\u0004\u0018\u00010\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010H\u0007J!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0007\u00a2\u0006\u0002\u0010\u0014J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0018"}, d2={"Lcom/airbnb/deeplinkdispatch/base/Utils;", "", "()V", "getBytes", "", "inputStream", "Ljava/io/InputStream;", "isConfigurablePathSegment", "", "pathSegment", "", "readMatchIndexFromStrings", "strings", "", "([Ljava/lang/String;)[B", "toByteArrayMap", "", "input", "toByteArraysList", "", "([Ljava/lang/String;)Ljava/util/List;", "validateIfComponentParam", "uriComponent", "validateIfConfigurablePathSegment", "deeplinkdispatch-base"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @JvmStatic
    @Nullable
    public static final byte[] readMatchIndexFromStrings(@NotNull String[] strings) {
        String it;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        if (strings.length == 0) {
            return new byte[0];
        }
        if (strings.length == 1) {
            String string = strings[0];
            Object object = Charset.forName("ISO_8859_1");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forName(charsetName)");
            object = string.getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).getBytes(charset)");
            return object;
        }
        Object object = strings;
        int n = 0;
        for (String string : object) {
            String string2 = string;
            int n2 = n;
            bl = false;
            int n3 = it.length();
            n = n2 + n3;
        }
        int n4 = n;
        StringBuilder fullString = new StringBuilder(n4);
        String[] $this$forEach$iv = strings;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            it = element$iv;
            bl = false;
            fullString.append(it);
        }
        object = fullString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fullString.toString()");
        Charset charset = Charset.forName("ISO_8859_1");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Map<byte[], byte[]> toByteArrayMap(@NotNull Map<String, String> input) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Iterable $this$associate$iv = input.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String string = (String)it.getKey();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            string = (String)it.getValue();
            byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            Pair pair = TuplesKt.to((Object)byArray2, (Object)byArray);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<byte[]> toByteArraysList(@NotNull String[] input) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String[] $this$map$iv = input;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_10 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_12 = it;
            byte[] byArray = var12_12.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            collection.add(byArray);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final byte[] getBytes(InputStream inputStream) {
        return ByteStreamsKt.readBytes((InputStream)inputStream);
    }

    public final boolean validateIfComponentParam(@NotNull String uriComponent) {
        Intrinsics.checkNotNullParameter((Object)uriComponent, (String)"uriComponent");
        int start = StringsKt.indexOf$default((CharSequence)uriComponent, (String)"{", (int)0, (boolean)false, (int)6, null);
        int end = StringsKt.indexOf$default((CharSequence)uriComponent, (String)"}", (int)0, (boolean)false, (int)6, null);
        if (start != -1 || end != -1) {
            if (!(start < end)) {
                boolean $i$a$-require-Utils$validateIfComponentParam$32 = false;
                String $i$a$-require-Utils$validateIfComponentParam$32 = "Invalid URI component: " + uriComponent + ". { must come before }.";
                throw new IllegalArgumentException($i$a$-require-Utils$validateIfComponentParam$32.toString());
            }
            if (!(start != -1 && end != -1)) {
                boolean bl = false;
                String string = "Invalid URI component: " + uriComponent + ". If either{ or } is present, then they must both be present and { must occur before }.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }
        return false;
    }

    public final boolean validateIfConfigurablePathSegment(@NotNull String pathSegment) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
        CharSequence charSequence = pathSegment;
        if (new Regex("<|>").containsMatchIn(charSequence)) {
            if (!Utils.isConfigurablePathSegment(pathSegment)) {
                boolean bl = false;
                String string = "Malformed path segment: " + pathSegment + "! If it contains < or >, it must start with < and end with >.";
                throw new IllegalArgumentException(string.toString());
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    public static final boolean isConfigurablePathSegment(@NotNull String pathSegment) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"pathSegment");
        return StringsKt.startsWith$default((String)pathSegment, (String)"<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)pathSegment, (String)">", (boolean)false, (int)2, null);
    }
}

