/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DeepLinkEntry {
    private static final String PARAM_VALUE = "([a-zA-Z0-9]*)";
    private static final String PARAM = "([a-zA-Z][a-zA-Z0-9_-]*)";
    private static final String PARAM_REGEX = "\\{(([a-zA-Z][a-zA-Z0-9_-]*))\\}";
    private final String hostPath;
    private final String regex;
    private final Type type;
    private final Class<?> activityClass;
    private final String method;

    public DeepLinkEntry(String hostPath, Type type, Class<?> activityClass, String method) {
        this.hostPath = hostPath;
        this.regex = this.generateLookupString(hostPath);
        this.type = type;
        this.activityClass = activityClass;
        this.method = method;
    }

    public String getRegex() {
        return this.regex;
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getActivityClass() {
        return this.activityClass;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getParameters(String inputHostPath) {
        Map<String, String> parameters = this.generateParameterMap(this.hostPath);
        this.populateParameters(inputHostPath, parameters);
        return parameters;
    }

    private Map<String, String> generateParameterMap(String hostPath) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        Pattern pattern = Pattern.compile(PARAM_REGEX);
        Matcher matcher = pattern.matcher(hostPath);
        while (matcher.find()) {
            paramMap.put(matcher.group(1), "");
        }
        return paramMap;
    }

    private void populateParameters(String inputHostPath, Map<String, String> parameters) {
        Iterator<String> keySetIterator = parameters.keySet().iterator();
        Matcher matcher = Pattern.compile(this.getRegex()).matcher(inputHostPath);
        matcher.matches();
        int i = 1;
        while (keySetIterator.hasNext()) {
            String key = keySetIterator.next();
            parameters.put(key, matcher.group(i));
            ++i;
        }
    }

    private String generateLookupString(String hostPath) {
        return hostPath.replaceAll(PARAM_REGEX, PARAM_VALUE);
    }

    public static enum Type {
        CLASS,
        METHOD;

    }
}

