/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import com.airbnb.deeplinkdispatch.DeepLinkEntry;
import com.airbnb.deeplinkdispatch.Loader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class DeepLinkRegistry {
    private final List<DeepLinkEntry> registry = new LinkedList<DeepLinkEntry>();

    public DeepLinkRegistry(Loader loader) {
        if (loader != null) {
            loader.load(this);
        }
    }

    public void registerDeepLink(String hostPath, DeepLinkEntry.Type type, Class<?> activityClass, String method) {
        this.registry.add(new DeepLinkEntry(hostPath, type, activityClass, method));
    }

    public DeepLinkEntry parseUri(String hostPath) {
        for (DeepLinkEntry entry : this.registry) {
            Matcher matcher = Pattern.compile(entry.getRegex()).matcher(hostPath);
            if (!matcher.matches()) continue;
            return entry;
        }
        return null;
    }
}

