/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import com.airbnb.deeplinkdispatch.DeepLinkUri;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DeepLinkEntry {
    private static final String PARAM_VALUE = "([a-zA-Z0-9_#'!+%~,\\-\\.\\@\\$\\:]+)";
    private static final String PARAM = "([a-zA-Z][a-zA-Z0-9_-]*)";
    private static final String PARAM_REGEX = "%7B(([a-zA-Z][a-zA-Z0-9_-]*))%7D";
    private static final Pattern PARAM_PATTERN = Pattern.compile("%7B(([a-zA-Z][a-zA-Z0-9_-]*))%7D");
    private final Type type;
    private final Class<?> activityClass;
    private final String method;
    private final Set<String> parameters;
    private final Pattern regex;

    public DeepLinkEntry(String uri, Type type, Class<?> activityClass, String method) {
        DeepLinkUri parsedUri = DeepLinkUri.parse(uri);
        String schemeHostAndPath = this.schemeHostAndPath(parsedUri);
        this.type = type;
        this.activityClass = activityClass;
        this.method = method;
        this.parameters = DeepLinkEntry.parseParameters(parsedUri);
        this.regex = Pattern.compile(schemeHostAndPath.replaceAll(PARAM_REGEX, PARAM_VALUE) + "$");
    }

    public Type getType() {
        return this.type;
    }

    public Class<?> getActivityClass() {
        return this.activityClass;
    }

    public String getMethod() {
        return this.method;
    }

    private static Set<String> parseParameters(DeepLinkUri uri) {
        Matcher matcher = PARAM_PATTERN.matcher(uri.encodedHost() + uri.encodedPath());
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (matcher.find()) {
            patterns.add(matcher.group(1));
        }
        return patterns;
    }

    public Map<String, String> getParameters(String inputUri) {
        Iterator<String> paramsIterator = this.parameters.iterator();
        HashMap<String, String> paramsMap = new HashMap<String, String>(this.parameters.size());
        DeepLinkUri deepLinkUri = DeepLinkUri.parse(inputUri);
        Matcher matcher = this.regex.matcher(this.schemeHostAndPath(deepLinkUri));
        int i = 1;
        if (matcher.matches()) {
            while (paramsIterator.hasNext()) {
                String value;
                String key = paramsIterator.next();
                if ((value = matcher.group(i++)) == null || "".equals(value.trim())) continue;
                paramsMap.put(key, value);
            }
        }
        return paramsMap;
    }

    private static String parsePath(DeepLinkUri parsedUri) {
        return parsedUri.encodedPath();
    }

    public boolean matches(String inputUri) {
        DeepLinkUri deepLinkUri = DeepLinkUri.parse(inputUri);
        return deepLinkUri != null && this.regex.matcher(this.schemeHostAndPath(deepLinkUri)).find();
    }

    private String schemeHostAndPath(DeepLinkUri uri) {
        return uri.scheme() + "://" + uri.encodedHost() + DeepLinkEntry.parsePath(uri);
    }

    public static enum Type {
        CLASS,
        METHOD;

    }
}

