/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.deeplinkdispatch;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.TaskStackBuilder;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.airbnb.deeplinkdispatch.BaseRegistry;
import com.airbnb.deeplinkdispatch.DeepLinkEntry;
import com.airbnb.deeplinkdispatch.DeepLinkResult;
import com.airbnb.deeplinkdispatch.DeepLinkUri;
import com.airbnb.deeplinkdispatch.ValidationUtilsKt;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseDeepLinkDelegate {
    protected static final String TAG = "DeepLinkDelegate";
    protected final List<? extends BaseRegistry> registries;
    protected final Map<String, String> configurablePathSegmentReplacements;

    public List<? extends BaseRegistry> getRegistries() {
        return this.registries;
    }

    public BaseDeepLinkDelegate(List<? extends BaseRegistry> registries) {
        this.registries = registries;
        this.configurablePathSegmentReplacements = new HashMap<String, String>();
    }

    public BaseDeepLinkDelegate(List<? extends BaseRegistry> registries, Map<String, String> configurablePathSegmentReplacements) {
        this.registries = registries;
        this.configurablePathSegmentReplacements = configurablePathSegmentReplacements;
        ValidationUtilsKt.validateConfigurablePathSegmentReplacements(registries, configurablePathSegmentReplacements);
    }

    private DeepLinkEntry findEntry(String uriString) {
        Object entryRegExpMatch = null;
        DeepLinkUri parse = DeepLinkUri.parse((String)uriString);
        for (BaseRegistry baseRegistry : this.registries) {
            DeepLinkEntry entryIdxMatch = baseRegistry.idxMatch(parse, this.configurablePathSegmentReplacements);
            if (entryIdxMatch == null) continue;
            return entryIdxMatch;
        }
        return null;
    }

    public DeepLinkResult dispatchFrom(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        return this.dispatchFrom(activity, activity.getIntent());
    }

    public DeepLinkResult dispatchFrom(Activity activity, Intent sourceIntent) {
        DeepLinkResult result = this.createResult(activity, sourceIntent, this.findEntry(sourceIntent.getData().toString()));
        if (result.getTaskStackBuilder() != null) {
            result.getTaskStackBuilder().startActivities();
        } else if (result.getIntent() != null) {
            activity.startActivity(result.getIntent());
        }
        BaseDeepLinkDelegate.notifyListener((Context)activity, !result.isSuccessful(), sourceIntent.getData(), result.getDeepLinkEntry() != null ? result.getDeepLinkEntry().getUriTemplate() : null, result.getError());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public DeepLinkResult createResult(Activity activity, Intent sourceIntent, DeepLinkEntry deepLinkEntry) {
        if (activity == null) {
            throw new NullPointerException("activity == null");
        }
        if (sourceIntent == null) {
            throw new NullPointerException("sourceIntent == null");
        }
        Uri uri = sourceIntent.getData();
        if (uri == null) {
            return new DeepLinkResult(false, null, "No Uri in given activity's intent.", null, null, deepLinkEntry);
        }
        String uriString = uri.toString();
        if (deepLinkEntry == null) {
            return new DeepLinkResult(false, null, "DeepLinkEntry cannot be null", null, null, null);
        }
        DeepLinkUri deepLinkUri = DeepLinkUri.parse((String)uriString);
        HashMap<Object, String> parameterMap = new HashMap<Object, String>(deepLinkEntry.getParameters(deepLinkUri));
        for (Object queryParameter : deepLinkUri.queryParameterNames()) {
            for (String queryParameterValue : deepLinkUri.queryParameterValues((String)queryParameter)) {
                if (parameterMap.containsKey(queryParameter)) {
                    Log.w((String)TAG, (String)("Duplicate parameter name in path and query param: " + (String)queryParameter));
                }
                parameterMap.put(queryParameter, queryParameterValue);
            }
        }
        parameterMap.put("deep_link_uri", uri.toString());
        Bundle parameters = sourceIntent.getExtras() != null ? new Bundle(sourceIntent.getExtras()) : new Bundle();
        for (Map.Entry entry : parameterMap.entrySet()) {
            parameters.putString((String)entry.getKey(), (String)entry.getValue());
        }
        try {
            void var10_23;
            Class c = deepLinkEntry.getActivityClass();
            Object var10_16 = null;
            TaskStackBuilder taskStackBuilder = null;
            if (deepLinkEntry.getType() == DeepLinkEntry.Type.CLASS) {
                Intent intent = new Intent((Context)activity, c);
            } else {
                DeepLinkResult errorResult = new DeepLinkResult(false, uriString, "Could not deep link to method: " + deepLinkEntry.getMethod() + " intents length == 0", null, null, deepLinkEntry);
                try {
                    Method method = c.getMethod(deepLinkEntry.getMethod(), Context.class);
                    if (method.getReturnType().equals(TaskStackBuilder.class)) {
                        taskStackBuilder = (TaskStackBuilder)method.invoke((Object)c, activity);
                        if (taskStackBuilder.getIntentCount() == 0) {
                            return errorResult;
                        }
                        Intent intent = taskStackBuilder.editIntentAt(taskStackBuilder.getIntentCount() - 1);
                    } else {
                        Intent intent = (Intent)method.invoke((Object)c, activity);
                    }
                }
                catch (NoSuchMethodException exception) {
                    Method method = c.getMethod(deepLinkEntry.getMethod(), Context.class, Bundle.class);
                    if (method.getReturnType().equals(TaskStackBuilder.class)) {
                        taskStackBuilder = (TaskStackBuilder)method.invoke((Object)c, activity, parameters);
                        if (taskStackBuilder.getIntentCount() == 0) {
                            return errorResult;
                        }
                        Intent intent = taskStackBuilder.editIntentAt(taskStackBuilder.getIntentCount() - 1);
                    }
                    Intent intent = (Intent)method.invoke((Object)c, activity, parameters);
                }
            }
            if (var10_23 == null) {
                return new DeepLinkResult(false, uriString, "Destination Intent is null!", null, taskStackBuilder, deepLinkEntry);
            }
            if (var10_23.getAction() == null) {
                var10_23.setAction(sourceIntent.getAction());
            }
            if (var10_23.getData() == null) {
                var10_23.setData(sourceIntent.getData());
            }
            var10_23.putExtras(parameters);
            var10_23.putExtra("is_deep_link_flag", true);
            var10_23.putExtra("android.intent.extra.REFERRER", (Parcelable)uri);
            if (activity.getCallingActivity() != null) {
                var10_23.setFlags(0x2000000);
            }
            return new DeepLinkResult(true, uriString, "", (Intent)var10_23, taskStackBuilder, deepLinkEntry);
        }
        catch (NoSuchMethodException exception) {
            return new DeepLinkResult(false, uriString, "Dee3p link to non-existent method: " + deepLinkEntry.getMethod(), null, null, deepLinkEntry);
        }
        catch (IllegalAccessException exception) {
            return new DeepLinkResult(false, uriString, "Could not deep link to method: " + deepLinkEntry.getMethod(), null, null, deepLinkEntry);
        }
        catch (InvocationTargetException exception) {
            return new DeepLinkResult(false, uriString, "Could not deep link to method: " + deepLinkEntry.getMethod(), null, null, deepLinkEntry);
        }
    }

    private static void notifyListener(Context context, boolean isError, Uri uri, String uriTemplate, String errorMessage) {
        Intent intent = new Intent();
        intent.setAction("com.airbnb.deeplinkdispatch.DEEPLINK_ACTION");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_URI", uri != null ? uri.toString() : "");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_URI_TEMPLATE", uriTemplate != null ? uriTemplate : "");
        intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_SUCCESSFUL", !isError);
        if (isError) {
            intent.putExtra("com.airbnb.deeplinkdispatch.EXTRA_ERROR_MESSAGE", errorMessage);
        }
        LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
    }

    public boolean supportsUri(String uriString) {
        return this.findEntry(uriString) != null;
    }
}

