/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class ExpressClassLoader
extends ClassLoader {
    public ExpressClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class<?> loadClass(String name, byte[] code) {
        return this.defineClass(name, code, 0, code.length);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clasz = ExpressClassLoader.findLoadedClass(this, name);
        if (clasz != null) {
            return clasz;
        }
        if (clasz == null) {
            clasz = ExpressClassLoader.parentLoadClass(this, name);
        }
        if (clasz == null && name.startsWith("[")) {
            int index = name.indexOf("L");
            String str = name.substring(0, index);
            String componentClassName = name.substring(index + 1, name.length() - 1);
            int[] dimes = new int[str.length()];
            for (int i = 0; i < dimes.length; ++i) {
                dimes[i] = 0;
            }
            try {
                Class<?> componentType = this.loadClass(componentClassName);
                clasz = Array.newInstance(componentType, dimes).getClass();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (clasz == null) {
            throw new ClassNotFoundException(name);
        }
        return clasz;
    }

    public static Class<?> findLoadedClass(ClassLoader loader, String name) throws ClassNotFoundException {
        Method m = null;
        try {
            m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            Class result = (Class)m.invoke((Object)loader, name);
            if (result == null) {
                result = (Class)m.invoke((Object)loader.getClass().getClassLoader(), name);
            }
            if (result == null) {
                result = (Class)m.invoke((Object)Thread.currentThread().getContextClassLoader(), name);
            }
            Class clazz = result;
            return clazz;
        }
        catch (Exception ex) {
            throw new ClassNotFoundException(ex.getMessage());
        }
        finally {
            if (m != null) {
                m.setAccessible(false);
            }
        }
    }

    public static Class<?> parentLoadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        Class<?> clasz = null;
        if (clasz == null) {
            try {
                clasz = loader.getClass().getClassLoader().loadClass(name);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (clasz == null) {
            try {
                clasz = Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clasz;
    }
}

