/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express;

import com.ql.util.express.DefaultExpressResourceLoader;
import com.ql.util.express.ExportItem;
import com.ql.util.express.ExpressLoader;
import com.ql.util.express.IExpressContext;
import com.ql.util.express.IExpressResourceLoader;
import com.ql.util.express.InstructionSet;
import com.ql.util.express.InstructionSetRunner;
import com.ql.util.express.Operator;
import com.ql.util.express.instruction.ForRelBreakContinue;
import com.ql.util.express.instruction.IOperateDataCache;
import com.ql.util.express.instruction.InstructionFactory;
import com.ql.util.express.instruction.OperateDataCacheImpl;
import com.ql.util.express.instruction.op.OperatorBase;
import com.ql.util.express.instruction.op.OperatorFactory;
import com.ql.util.express.instruction.op.OperatorInstanceOf;
import com.ql.util.express.instruction.op.OperatorMinMax;
import com.ql.util.express.instruction.op.OperatorPrint;
import com.ql.util.express.instruction.op.OperatorPrintln;
import com.ql.util.express.instruction.op.OperatorRound;
import com.ql.util.express.instruction.op.OperatorSelfDefineClassFunction;
import com.ql.util.express.instruction.op.OperatorSelfDefineServiceFunction;
import com.ql.util.express.parse.AppendingClassFieldManager;
import com.ql.util.express.parse.AppendingClassMethodManager;
import com.ql.util.express.parse.ExpressNode;
import com.ql.util.express.parse.ExpressPackage;
import com.ql.util.express.parse.ExpressParse;
import com.ql.util.express.parse.NodeType;
import com.ql.util.express.parse.NodeTypeManager;
import com.ql.util.express.parse.Word;
import com.ql.util.express.rule.Condition;
import com.ql.util.express.rule.Rule;
import com.ql.util.express.rule.RuleManager;
import com.ql.util.express.rule.RuleResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressRunner {
    private static final Log log = LogFactory.getLog(ExpressRunner.class);
    private static final String GLOBAL_DEFINE_NAME = "\u5168\u5c40\u5b9a\u4e49";
    private boolean isTrace = false;
    private boolean isShortCircuit = true;
    private boolean isPrecise = false;
    private Map<String, InstructionSet> expressInstructionSetCache = new HashMap<String, InstructionSet>();
    private Map<String, Rule> ruleCache = new HashMap<String, Rule>();
    private ExpressLoader loader;
    private IExpressResourceLoader expressResourceLoader;
    private NodeTypeManager manager;
    private OperatorFactory operatorManager;
    private ExpressParse parse;
    ExpressPackage rootExpressPackage = new ExpressPackage(null);
    private AppendingClassMethodManager appendingClassMethodManager;
    private AppendingClassFieldManager appendingClassFieldManager;
    private ThreadLocal<IOperateDataCache> m_OperateDataObjectCache = new ThreadLocal<IOperateDataCache>(){

        @Override
        protected IOperateDataCache initialValue() {
            return new OperateDataCacheImpl(30);
        }
    };
    static Pattern patternRule = Pattern.compile("rule[\\s]+'([^']+)'[\\s]+name[\\s]+'([^']+)'[\\s]+");

    public AppendingClassMethodManager getAppendingClassMethodManager() {
        return this.appendingClassMethodManager;
    }

    public AppendingClassFieldManager getAppendingClassFieldManager() {
        return this.appendingClassFieldManager;
    }

    public IOperateDataCache getOperateDataCache() {
        return this.m_OperateDataObjectCache.get();
    }

    public ExpressRunner() {
        this(false, false);
    }

    public ExpressRunner(boolean aIsPrecise, boolean aIstrace) {
        this(aIsPrecise, aIstrace, new DefaultExpressResourceLoader(), null);
    }

    public ExpressRunner(boolean aIsPrecise, boolean aIstrace, NodeTypeManager aManager) {
        this(aIsPrecise, aIstrace, new DefaultExpressResourceLoader(), aManager);
    }

    public ExpressRunner(boolean aIsPrecise, boolean aIstrace, IExpressResourceLoader aExpressResourceLoader, NodeTypeManager aManager) {
        this.isTrace = aIstrace;
        this.isPrecise = aIsPrecise;
        this.expressResourceLoader = aExpressResourceLoader;
        this.manager = aManager == null ? new NodeTypeManager() : aManager;
        this.operatorManager = new OperatorFactory(this.isPrecise);
        this.loader = new ExpressLoader(this);
        this.parse = new ExpressParse(this.manager, this.expressResourceLoader, this.isPrecise);
        this.rootExpressPackage.addPackage("java.lang");
        this.rootExpressPackage.addPackage("java.util");
        this.addSystemFunctions();
        this.addSystemOperators();
    }

    private void addSystemOperators() {
        try {
            this.addOperator("instanceof", new OperatorInstanceOf("instanceof"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSystemFunctions() {
        this.addFunction("max", new OperatorMinMax("max"));
        this.addFunction("min", new OperatorMinMax("min"));
        this.addFunction("round", new OperatorRound("round"));
        this.addFunction("print", new OperatorPrint("print"));
        this.addFunction("println", new OperatorPrintln("println"));
    }

    public NodeTypeManager getNodeTypeManager() {
        return this.manager;
    }

    public OperatorFactory getOperatorFactory() {
        return this.operatorManager;
    }

    public IExpressResourceLoader getExpressResourceLoader() {
        return this.expressResourceLoader;
    }

    public void addMacro(String macroName, String express) throws Exception {
        String macroExpress = "macro " + macroName + " {" + express + "}";
        this.loader.parseInstructionSet(GLOBAL_DEFINE_NAME, macroExpress);
    }

    public void loadMutilExpress(String groupName, String express) throws Exception {
        if (groupName == null || groupName.trim().length() == 0) {
            groupName = GLOBAL_DEFINE_NAME;
        }
        this.loader.parseInstructionSet(groupName, express);
    }

    public void loadExpress(String expressName) throws Exception {
        this.loader.loadExpress(expressName);
    }

    public void addFunction(String name, OperatorBase op) {
        this.operatorManager.addOperator(name, op);
        this.manager.addFunctionName(name);
    }

    public void addFunctionAndClassMethod(String name, Class<?> bindingClass, OperatorBase op) {
        this.addFunction(name, op);
        this.addClassMethod(name, bindingClass, op);
    }

    public void addClassField(String field, Class<?> bindingClass, Operator op) {
        this.addClassField(field, bindingClass, Object.class, op);
    }

    public void addClassField(String field, Class<?> bindingClass, Class<?> returnType, Operator op) {
        if (this.appendingClassFieldManager == null) {
            this.appendingClassFieldManager = new AppendingClassFieldManager();
        }
        this.appendingClassFieldManager.addAppendingField(field, bindingClass, returnType, op);
    }

    public void addClassMethod(String name, Class<?> bindingClass, OperatorBase op) {
        if (this.appendingClassMethodManager == null) {
            this.appendingClassMethodManager = new AppendingClassMethodManager();
        }
        this.appendingClassMethodManager.addAppendingMethod(name, bindingClass, op);
    }

    public OperatorBase getFunciton(String name) {
        return this.operatorManager.getOperator(name);
    }

    public void addFunctionOfClassMethod(String name, String aClassName, String aFunctionName, Class<?>[] aParameterClassTypes, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineClassFunction(name, aClassName, aFunctionName, aParameterClassTypes, null, null, errorInfo));
    }

    public void addFunctionOfClassMethod(String name, String aClassName, String aFunctionName, Class<?>[] aParameterClassTypes, String[] aParameterDesc, String[] aParameterAnnotation, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineClassFunction(name, aClassName, aFunctionName, aParameterClassTypes, aParameterDesc, aParameterAnnotation, errorInfo));
    }

    public void addFunctionOfClassMethod(String name, String aClassName, String aFunctionName, String[] aParameterTypes, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineClassFunction(name, aClassName, aFunctionName, aParameterTypes, null, null, errorInfo));
    }

    public void addFunctionOfClassMethod(String name, String aClassName, String aFunctionName, String[] aParameterTypes, String[] aParameterDesc, String[] aParameterAnnotation, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineClassFunction(name, aClassName, aFunctionName, aParameterTypes, aParameterDesc, aParameterAnnotation, errorInfo));
    }

    public void addFunctionOfServiceMethod(String name, Object aServiceObject, String aFunctionName, Class<?>[] aParameterClassTypes, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineServiceFunction(name, aServiceObject, aFunctionName, aParameterClassTypes, null, null, errorInfo));
    }

    public void addFunctionOfServiceMethod(String name, Object aServiceObject, String aFunctionName, Class<?>[] aParameterClassTypes, String[] aParameterDesc, String[] aParameterAnnotation, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineServiceFunction(name, aServiceObject, aFunctionName, aParameterClassTypes, aParameterDesc, aParameterAnnotation, errorInfo));
    }

    public void addFunctionOfServiceMethod(String name, Object aServiceObject, String aFunctionName, String[] aParameterTypes, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineServiceFunction(name, aServiceObject, aFunctionName, aParameterTypes, null, null, errorInfo));
    }

    public void addFunctionOfServiceMethod(String name, Object aServiceObject, String aFunctionName, String[] aParameterTypes, String[] aParameterDesc, String[] aParameterAnnotation, String errorInfo) throws Exception {
        this.addFunction(name, new OperatorSelfDefineServiceFunction(name, aServiceObject, aFunctionName, aParameterTypes, aParameterDesc, aParameterAnnotation, errorInfo));
    }

    public void addOperator(String name, Operator op) throws Exception {
        this.addOperator(name, "*", op);
    }

    public void addOperator(String name, String aRefOpername, Operator op) throws Exception {
        this.manager.addOperatorWithLevelOfReference(name, aRefOpername);
        this.operatorManager.addOperator(name, op);
    }

    public void addOperatorWithAlias(String keyWordName, String realKeyWordName, String errorInfo) throws Exception {
        if (errorInfo != null && errorInfo.trim().length() == 0) {
            errorInfo = null;
        }
        if (this.manager.isFunction(realKeyWordName)) {
            this.manager.addFunctionName(keyWordName);
            this.operatorManager.addOperatorWithAlias(keyWordName, realKeyWordName, errorInfo);
            return;
        }
        NodeType realNodeType = this.manager.findNodeType(realKeyWordName);
        if (realNodeType == null) {
            throw new Exception("\u5173\u952e\u5b57\uff1a" + realKeyWordName + "\u4e0d\u5b58\u5728");
        }
        boolean isExist = this.operatorManager.isExistOperator(realNodeType.getName());
        if (!isExist && errorInfo != null) {
            throw new Exception("\u5173\u952e\u5b57\uff1a" + realKeyWordName + "\u662f\u901a\u8fc7\u6307\u4ee4\u6765\u5b9e\u73b0\u7684\uff0c\u4e0d\u80fd\u8bbe\u7f6e\u9519\u8bef\u7684\u63d0\u793a\u4fe1\u606f\uff0cerrorInfo \u5fc5\u987b\u662f null");
        }
        if (!isExist || errorInfo == null) {
            this.manager.addOperatorWithRealNodeType(keyWordName, realNodeType.getName());
        } else {
            this.manager.addOperatorWithLevelOfReference(keyWordName, realNodeType.getName());
            this.operatorManager.addOperatorWithAlias(keyWordName, realNodeType.getName(), errorInfo);
        }
    }

    public OperatorBase replaceOperator(String name, OperatorBase op) {
        return this.operatorManager.replaceOperator(name, op);
    }

    public ExpressPackage getRootExpressPackage() {
        return this.rootExpressPackage;
    }

    public void clearExpressCache() {
        this.expressInstructionSetCache.clear();
    }

    public Object executeByExpressName(String name, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException, Log aLog) throws Exception {
        return InstructionSetRunner.executeOuter(this, this.loader.getInstructionSet(name), this.loader, context, errorList, isTrace, isCatchException, aLog, false);
    }

    @Deprecated
    public Object execute(InstructionSet[] instructionSets, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException, Log aLog) throws Exception {
        return InstructionSetRunner.executeOuter(this, instructionSets[0], this.loader, context, errorList, isTrace, isCatchException, aLog, false);
    }

    public Object execute(InstructionSet instructionSets, IExpressContext<String, Object> context, List<String> errorList, boolean isTrace, boolean isCatchException, Log aLog) throws Exception {
        return InstructionSetRunner.executeOuter(this, instructionSets, this.loader, context, errorList, isTrace, isCatchException, aLog, false);
    }

    public Object execute(String expressString, IExpressContext<String, Object> context, List<String> errorList, boolean isCache, boolean isTrace) throws Exception {
        return this.execute(expressString, context, errorList, isCache, isTrace, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String expressString, IExpressContext<String, Object> context, List<String> errorList, boolean isCache, boolean isTrace, Log aLog) throws Exception {
        InstructionSet parseResult = null;
        if (isCache) {
            parseResult = this.expressInstructionSetCache.get(expressString);
            if (parseResult == null) {
                Map<String, InstructionSet> map = this.expressInstructionSetCache;
                synchronized (map) {
                    parseResult = this.expressInstructionSetCache.get(expressString);
                    if (parseResult == null) {
                        parseResult = this.parseInstructionSet(expressString);
                        this.expressInstructionSetCache.put(expressString, parseResult);
                    }
                }
            }
        } else {
            parseResult = this.parseInstructionSet(expressString);
        }
        return InstructionSetRunner.executeOuter(this, parseResult, this.loader, context, errorList, isTrace, false, aLog, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleResult executeRule(String expressString, IExpressContext<String, Object> context, boolean isCache, boolean isTrace) throws Exception {
        Rule rule = null;
        if (isCache) {
            rule = this.ruleCache.get(expressString);
            if (rule == null) {
                Map<String, Rule> map = this.ruleCache;
                synchronized (map) {
                    rule = this.ruleCache.get(expressString);
                    if (rule == null) {
                        rule = this.parseRule(expressString);
                        this.ruleCache.put(expressString, rule);
                    }
                }
            }
        } else {
            rule = this.parseRule(expressString);
        }
        return RuleManager.executeRule(this, rule, context, isCache, isTrace);
    }

    public Rule parseRule(String text) throws Exception {
        String ruleName = null;
        String ruleCode = null;
        Matcher matcher = patternRule.matcher(text);
        if (matcher.find()) {
            ruleCode = matcher.group(1);
            ruleName = matcher.group(2);
            text = text.substring(matcher.end());
        }
        HashMap<String, String> selfDefineClass = new HashMap<String, String>();
        for (ExportItem item : this.loader.getExportInfo()) {
            if (!item.getType().equals(InstructionSet.TYPE_CLASS)) continue;
            selfDefineClass.put(item.getName(), item.getName());
        }
        Word[] words = this.parse.splitWords(this.rootExpressPackage, text, this.isTrace, selfDefineClass);
        ExpressNode root = this.parse.parse(this.rootExpressPackage, words, text, this.isTrace, selfDefineClass);
        Rule rule = RuleManager.createRule(root, words);
        rule.setCode(ruleCode);
        rule.setName(ruleName);
        return rule;
    }

    public Condition parseContition(String text) throws Exception {
        HashMap<String, String> selfDefineClass = new HashMap<String, String>();
        for (ExportItem item : this.loader.getExportInfo()) {
            if (!item.getType().equals(InstructionSet.TYPE_CLASS)) continue;
            selfDefineClass.put(item.getName(), item.getName());
        }
        Word[] words = this.parse.splitWords(this.rootExpressPackage, text, this.isTrace, selfDefineClass);
        ExpressNode root = this.parse.parse(this.rootExpressPackage, words, text, this.isTrace, selfDefineClass);
        return RuleManager.createCondition(root, words);
    }

    public InstructionSet parseInstructionSet(String text) throws Exception {
        HashMap<String, String> selfDefineClass = new HashMap<String, String>();
        for (ExportItem item : this.loader.getExportInfo()) {
            if (!item.getType().equals(InstructionSet.TYPE_CLASS)) continue;
            selfDefineClass.put(item.getName(), item.getName());
        }
        ExpressNode root = this.parse.parse(this.rootExpressPackage, text, this.isTrace, selfDefineClass);
        InstructionSet result = this.createInstructionSet(root, "main");
        if (this.isTrace && log.isDebugEnabled()) {
            log.debug((Object)result);
        }
        return result;
    }

    public ExportItem[] getExportInfo() {
        return this.loader.getExportInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstructionSet getInstructionSetFromLocalCache(String expressString) throws Exception {
        InstructionSet parseResult = this.expressInstructionSetCache.get(expressString);
        if (parseResult == null) {
            Map<String, InstructionSet> map = this.expressInstructionSetCache;
            synchronized (map) {
                parseResult = this.expressInstructionSetCache.get(expressString);
                if (parseResult == null) {
                    parseResult = this.parseInstructionSet(expressString);
                    this.expressInstructionSetCache.put(expressString, parseResult);
                }
            }
        }
        return parseResult;
    }

    public InstructionSet createInstructionSet(ExpressNode root, String type) throws Exception {
        InstructionSet result = new InstructionSet(type);
        this.createInstructionSet(root, result);
        return result;
    }

    public void createInstructionSet(ExpressNode root, InstructionSet result) throws Exception {
        Stack<ForRelBreakContinue> forStack = new Stack<ForRelBreakContinue>();
        this.createInstructionSetPrivate(result, forStack, root, true);
        if (forStack.size() > 0) {
            throw new Exception("For\u5904\u7406\u9519\u8bef");
        }
    }

    public boolean createInstructionSetPrivate(InstructionSet result, Stack<ForRelBreakContinue> forStack, ExpressNode node, boolean isRoot) throws Exception {
        InstructionFactory factory = InstructionFactory.getInstructionFactory(node.getInstructionFactory());
        boolean hasLocalVar = factory.createInstruction(this, result, forStack, node, isRoot);
        return hasLocalVar;
    }

    public String[] getOutVarNames(String express) throws Exception {
        return this.parseInstructionSet(express).getOutAttrNames();
    }

    public String[] getOutFunctionNames(String express) throws Exception {
        return this.parseInstructionSet(express).getOutFunctionNames();
    }

    public boolean isShortCircuit() {
        return this.isShortCircuit;
    }

    public void setShortCircuit(boolean isShortCircuit) {
        this.isShortCircuit = isShortCircuit;
    }
}

