/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.instruction.op;

import com.ql.util.express.ArraySwap;
import com.ql.util.express.ExpressUtil;
import com.ql.util.express.InstructionSetContext;
import com.ql.util.express.OperateData;
import com.ql.util.express.instruction.OperateDataCacheManager;
import com.ql.util.express.instruction.op.OperatorBase;
import java.lang.reflect.Array;

public class OperatorAnonymousNewArray
extends OperatorBase {
    public OperatorAnonymousNewArray(String aName) {
        this.name = aName;
    }

    public OperatorAnonymousNewArray(String aAliasName, String aName, String aErrorInfo) {
        this.name = aName;
        this.aliasName = aAliasName;
        this.errorInfo = aErrorInfo;
    }

    @Override
    public OperateData executeInner(InstructionSetContext context, ArraySwap list) throws Exception {
        Class<?> type = this.findArrayClassType(context, list);
        type = ExpressUtil.getSimpleDataType(type);
        int[] dims = new int[]{list.length};
        Object data = Array.newInstance(type, dims);
        for (int i = 0; i < list.length; ++i) {
            Array.set(data, i, list.get(i).getObject(context));
        }
        return OperateDataCacheManager.fetchOperateData(data, data.getClass());
    }

    private Class<?> findArrayClassType(InstructionSetContext context, ArraySwap list) throws Exception {
        Class type = null;
        for (int i = 0; i < list.length; ++i) {
            Class<?> type1 = list.get(i).getType(context);
            if (type1 == null) continue;
            if (type == null) {
                type = type1;
                continue;
            }
            if (type1 == type || type.isAssignableFrom(type1)) continue;
            type = type1.isAssignableFrom(type) ? type1 : Object.class;
        }
        if (type == null) {
            type = Object.class;
        }
        return type;
    }
}

