/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MapDeserializer
implements ObjectDeserializer {
    public static MapDeserializer instance = new MapDeserializer();

    MapDeserializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        if (type == JSONObject.class && parser.fieldTypeResolver == null) {
            return (T)parser.parseObject();
        }
        JSONLexer lexer = parser.lexer;
        if (lexer.token == 8) {
            lexer.nextToken(16);
            return null;
        }
        Map<Object, Object> map = this.createMap(type);
        ParseContext context = parser.contex;
        try {
            parser.setContext(context, map, fieldName);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type keyType = parameterizedType.getActualTypeArguments()[0];
                Type valueType = parameterizedType.getActualTypeArguments()[1];
                if (String.class == keyType) {
                    Map map2 = MapDeserializer.parseMap(parser, map, valueType, fieldName);
                    return (T)map2;
                }
                Object object = MapDeserializer.parseMap(parser, map, keyType, valueType, fieldName);
                return (T)object;
            }
            Object object = parser.parseObject(map, fieldName);
            return (T)object;
        }
        finally {
            parser.setContext(context);
        }
    }

    public static Map parseMap(DefaultJSONParser parser, Map<String, Object> map, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token != 12) {
            throw new JSONException("syntax error, expect {, actual " + lexer.token);
        }
        ParseContext context = parser.contex;
        try {
            while (true) {
                Object value;
                String key;
                lexer.skipWhitespace();
                char ch = lexer.ch;
                while (ch == ',') {
                    lexer.next();
                    lexer.skipWhitespace();
                    ch = lexer.ch;
                }
                if (ch == '\"') {
                    key = lexer.scanSymbol(parser.symbolTable, '\"');
                    lexer.skipWhitespace();
                    ch = lexer.ch;
                    if (ch != ':') {
                        throw new JSONException("syntax error, " + lexer.info());
                    }
                } else {
                    if (ch == '}') {
                        lexer.next();
                        lexer.sp = 0;
                        lexer.nextToken(16);
                        Map<String, Object> map2 = map;
                        return map2;
                    }
                    if (ch == '\'') {
                        key = lexer.scanSymbol(parser.symbolTable, '\'');
                        lexer.skipWhitespace();
                        ch = lexer.ch;
                        if (ch != ':') {
                            throw new JSONException("syntax error, " + lexer.info());
                        }
                    } else {
                        key = lexer.scanSymbolUnQuoted(parser.symbolTable);
                        lexer.skipWhitespace();
                        ch = lexer.ch;
                        if (ch != ':') {
                            throw new JSONException("expect ':' at " + lexer.pos + ", actual " + ch);
                        }
                    }
                }
                lexer.next();
                lexer.skipWhitespace();
                ch = lexer.ch;
                lexer.sp = 0;
                if (key == "@type" && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                    String typeName = lexer.scanSymbol(parser.symbolTable, '\"');
                    Class<?> clazz = TypeUtils.loadClass(typeName, parser.config.defaultClassLoader);
                    if (clazz == map.getClass()) {
                        lexer.nextToken(16);
                        if (lexer.token != 13) continue;
                        lexer.nextToken(16);
                        Map<String, Object> map3 = map;
                        return map3;
                    }
                    ObjectDeserializer deserializer = parser.config.getDeserializer(clazz);
                    lexer.nextToken(16);
                    parser.resolveStatus = 2;
                    if (context != null && !(fieldName instanceof Integer)) {
                        parser.popContext();
                    }
                    Map map4 = (Map)deserializer.deserialze(parser, clazz, fieldName);
                    return map4;
                }
                lexer.nextToken();
                parser.setContext(context);
                if (lexer.token == 8) {
                    value = null;
                    lexer.nextToken();
                } else {
                    value = parser.parseObject(valueType, (Object)key);
                }
                map.put(key, value);
                if (parser.resolveStatus == 1) {
                    parser.checkMapResolve(map, key);
                }
                parser.setContext(context, value, key);
                int tok = lexer.token;
                if (tok == 20 || tok == 15) {
                    Map<String, Object> map5 = map;
                    return map5;
                }
                if (tok != 13) continue;
                lexer.nextToken();
                Map<String, Object> map6 = map;
                return map6;
            }
        }
        finally {
            parser.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseMap(DefaultJSONParser parser, Map<Object, Object> map, Type keyType, Type valueType, Object fieldName) {
        JSONLexer lexer = parser.lexer;
        int token = lexer.token;
        if (token != 12 && token != 16) {
            throw new JSONException("syntax error, expect {, actual " + JSONToken.name(token));
        }
        ObjectDeserializer keyDeserializer = parser.config.getDeserializer(keyType);
        ObjectDeserializer valueDeserializer = parser.config.getDeserializer(valueType);
        lexer.nextToken();
        ParseContext context = parser.contex;
        try {
            while (true) {
                Object object;
                if ((token = lexer.token) == 13) {
                    lexer.nextToken(16);
                    break;
                }
                if (token == 4 && lexer.sp == 4 && lexer.text.startsWith("$ref", lexer.np + 1) && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                    Object ref;
                    object = null;
                    lexer.nextTokenWithChar(':');
                    if (lexer.token == 4) {
                        ref = lexer.stringVal();
                        if ("..".equals(ref)) {
                            ParseContext parentContext = context.parent;
                            object = parentContext.object;
                        } else if ("$".equals(ref)) {
                            ParseContext rootContext = context;
                            while (rootContext.parent != null) {
                                rootContext = rootContext.parent;
                            }
                            object = rootContext.object;
                        } else {
                            parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                            parser.resolveStatus = 1;
                        }
                    } else {
                        throw new JSONException("illegal ref, " + JSONToken.name(token));
                    }
                    lexer.nextToken(13);
                    if (lexer.token != 13) {
                        throw new JSONException("illegal ref");
                    }
                    lexer.nextToken(16);
                    ref = object;
                    return ref;
                }
                if (map.size() == 0 && token == 4 && "@type".equals(lexer.stringVal()) && !lexer.isEnabled(Feature.DisableSpecialKeyDetect)) {
                    lexer.nextTokenWithChar(':');
                    lexer.nextToken(16);
                    if (lexer.token == 13) {
                        lexer.nextToken();
                        object = map;
                        return object;
                    }
                    lexer.nextToken();
                }
                Object key = keyDeserializer.deserialze(parser, keyType, null);
                if (lexer.token != 17) {
                    throw new JSONException("syntax error, expect :, actual " + lexer.token);
                }
                lexer.nextToken();
                Object value = valueDeserializer.deserialze(parser, valueType, key);
                if (parser.resolveStatus == 1) {
                    parser.checkMapResolve(map, key);
                }
                map.put(key, value);
                if (lexer.token != 16) continue;
                lexer.nextToken();
            }
        }
        finally {
            parser.setContext(context);
        }
        return map;
    }

    protected Map<?, ?> createMap(Type type) {
        if (type == Properties.class) {
            return new Properties();
        }
        if (type == Hashtable.class) {
            return new Hashtable();
        }
        if (type == IdentityHashMap.class) {
            return new IdentityHashMap();
        }
        if (type == SortedMap.class || type == TreeMap.class) {
            return new TreeMap();
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return new ConcurrentHashMap();
        }
        if (type == Map.class || type == HashMap.class) {
            return new HashMap();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if (type == JSONObject.class) {
            return new JSONObject();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (EnumMap.class.equals((Object)rawType)) {
                Type[] actualArgs = parameterizedType.getActualTypeArguments();
                return new EnumMap((Class)actualArgs[0]);
            }
            return this.createMap(rawType);
        }
        Class clazz = (Class)type;
        if (clazz.isInterface()) {
            throw new JSONException("unsupport type " + type);
        }
        try {
            return (Map)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JSONException("unsupport type " + type, e);
        }
    }
}

