/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.config;

import com.alicp.jetcache.anno.aop.CacheAdvisor;
import com.alicp.jetcache.anno.aop.JetCacheInterceptor;
import com.alicp.jetcache.anno.config.EnableMethodCache;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class JetCacheProxyConfiguration
implements ImportAware,
ApplicationContextAware {
    protected AnnotationAttributes enableMethodCache;
    private ApplicationContext applicationContext;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableMethodCache = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMethodCache.class.getName(), false));
        if (this.enableMethodCache == null) {
            throw new IllegalArgumentException("@EnableMethodCache is not present on importing class " + importMetadata.getClassName());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean(name={"jetcache2.internalCacheAdvisor"})
    @Role(value=2)
    public CacheAdvisor jetcacheAdvisor() {
        ConcurrentHashMap<String, CacheInvokeConfig> configMap = new ConcurrentHashMap<String, CacheInvokeConfig>();
        JetCacheInterceptor jetCacheInterceptor = new JetCacheInterceptor();
        jetCacheInterceptor.setCacheConfigMap(configMap);
        jetCacheInterceptor.setApplicationContext(this.applicationContext);
        CacheAdvisor advisor = new CacheAdvisor();
        advisor.setAdviceBeanName("jetcache2.internalCacheAdvisor");
        advisor.setAdvice((Advice)jetCacheInterceptor);
        advisor.setBasePackages(this.enableMethodCache.getStringArray("basePackages"));
        advisor.setCacheConfigMap(configMap);
        advisor.setOrder((Integer)this.enableMethodCache.getNumber("order"));
        return advisor;
    }
}

