/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.method.ExpressionUtil;
import com.alicp.jetcache.anno.support.CacheAnnoConfig;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.event.CacheEvent;
import com.alicp.jetcache.event.CacheLoadEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(CacheHandler.class);
    private Object src;
    private Supplier<CacheInvokeContext> contextSupplier;
    private String[] hiddenPackages;
    private CacheInvokeConfig cacheInvokeConfig;
    private HashMap<String, CacheInvokeConfig> configMap;

    public CacheHandler(Object src, CacheInvokeConfig cacheInvokeConfig, Supplier<CacheInvokeContext> contextSupplier, String[] hiddenPackages) {
        this.src = src;
        this.cacheInvokeConfig = cacheInvokeConfig;
        this.contextSupplier = contextSupplier;
        this.hiddenPackages = hiddenPackages;
    }

    public CacheHandler(Object src, HashMap<String, CacheInvokeConfig> configMap, Supplier<CacheInvokeContext> contextSupplier, String[] hiddenPackages) {
        this.src = src;
        this.configMap = configMap;
        this.contextSupplier = contextSupplier;
        this.hiddenPackages = hiddenPackages;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CacheInvokeContext context = null;
        if (this.cacheInvokeConfig != null) {
            context = this.contextSupplier.get();
            context.cacheInvokeConfig = this.cacheInvokeConfig;
        } else {
            String sig = ClassUtil.getMethodSig(method);
            CacheInvokeConfig cac = this.configMap.get(sig);
            if (cac != null) {
                context = this.contextSupplier.get();
                context.cacheInvokeConfig = cac;
            }
        }
        if (context == null) {
            return method.invoke(this.src, args);
        }
        context.invoker = () -> method.invoke(this.src, args);
        context.hiddenPackages = this.hiddenPackages;
        context.args = args;
        context.method = method;
        return CacheHandler.invoke(context);
    }

    public static Object invoke(CacheInvokeContext context) throws Throwable {
        if (context.cacheInvokeConfig.isEnableCacheContext()) {
            try {
                CacheContextSupport._enable();
                Object object = CacheHandler.doInvoke(context);
                return object;
            }
            finally {
                CacheContextSupport._disable();
            }
        }
        return CacheHandler.doInvoke(context);
    }

    private static Object doInvoke(CacheInvokeContext context) throws Throwable {
        CacheAnnoConfig cacheAnnoConfig = context.cacheInvokeConfig.getCacheAnnoConfig();
        if (cacheAnnoConfig != null && (cacheAnnoConfig.isEnabled() || CacheContextSupport._isEnabled())) {
            return CacheHandler.invokeWithCache(context);
        }
        return CacheHandler.invokeOrigin(context);
    }

    private static Object invokeWithCache(CacheInvokeContext context) throws Throwable {
        Cache cache = context.cacheFunction.apply(context);
        if (cache == null) {
            logger.error("no cache with name: " + context.method);
            return CacheHandler.invokeOrigin(context);
        }
        Object key = context.args;
        if (key == null) {
            key = "_$JETCACHE_NULL_KEY$_";
        }
        if (!ExpressionUtil.evalCondition(context)) {
            return CacheHandler.loadAndCount(context, cache, key);
        }
        CacheGetResult cacheGetResult = cache.GET(key);
        if (cacheGetResult.isSuccess()) {
            context.result = cacheGetResult.getValue();
        }
        if (!cacheGetResult.isSuccess()) {
            context.result = CacheHandler.loadAndCount(context, cache, key);
            if (!CacheHandler.canNotCache(context)) {
                cache.put(key, context.result);
            }
        } else if (CacheHandler.canNotCache(context)) {
            context.result = CacheHandler.loadAndCount(context, cache, key);
            if (!CacheHandler.canNotCache(context)) {
                cache.put(key, context.result);
            }
        }
        return context.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object loadAndCount(CacheInvokeContext context, Cache cache, Object key) throws Throwable {
        long t = System.currentTimeMillis();
        Object v = null;
        boolean success = false;
        try {
            v = CacheHandler.invokeOrigin(context);
            success = true;
        }
        finally {
            t = System.currentTimeMillis() - t;
            CacheLoadEvent event = new CacheLoadEvent(cache, t, key, v, success);
            while (cache instanceof ProxyCache) {
                cache = ((ProxyCache)cache).getTargetCache();
            }
            if (cache instanceof AbstractCache) {
                ((AbstractCache)cache).notify((CacheEvent)event);
            }
        }
        return v;
    }

    private static boolean canNotCache(CacheInvokeContext context) {
        return ExpressionUtil.evalUnless(context) || context.result == null && !context.cacheInvokeConfig.getCacheAnnoConfig().isCacheNullValue();
    }

    private static Object invokeOrigin(CacheInvokeContext context) throws Throwable {
        return context.invoker.invoke();
    }

    private static class CacheContextSupport
    extends CacheContext {
        public CacheContextSupport() {
            super(null);
        }

        static void _enable() {
            CacheContextSupport.enable();
        }

        static void _disable() {
            CacheContextSupport.disable();
        }

        static boolean _isEnabled() {
            return CacheContextSupport.isEnabled();
        }
    }
}

