/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.springframework.asm.Type;

public class ClassUtil {
    private static ConcurrentHashMap<Method, String> cacheNameMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<Method, String> methodSigMap = new ConcurrentHashMap();

    public static String generateCacheName(Method method, String[] hiddenPackages) {
        String prefix = cacheNameMap.get(method);
        if (prefix == null) {
            StringBuilder sb = new StringBuilder();
            String className = method.getDeclaringClass().getName();
            sb.append(ClassUtil.getShortClassName(ClassUtil.removeHiddenPackage(hiddenPackages, className)));
            sb.append('.');
            sb.append(method.getName());
            sb.append('(');
            for (Class<?> c : method.getParameterTypes()) {
                ClassUtil.getDescriptor(sb, c, hiddenPackages);
            }
            sb.append(')');
            String str = sb.toString();
            cacheNameMap.put(method, str);
            return str;
        }
        return prefix;
    }

    private static void getDescriptor(StringBuilder sb, Class<?> c, String[] hiddenPackages) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                sb.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            sb.append('[');
            d = d.getComponentType();
        }
        sb.append('L');
        String name = d.getName();
        name = ClassUtil.removeHiddenPackage(hiddenPackages, name);
        name = ClassUtil.getShortClassName(name);
        sb.append(name);
        sb.append(';');
    }

    public static String getShortClassName(String className) {
        if (className == null) {
            return null;
        }
        String[] ss = className.split("\\.");
        StringBuilder sb = new StringBuilder(className.length());
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            if (i != ss.length - 1) {
                sb.append(s.charAt(0)).append('.');
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String removeHiddenPackage(String[] hiddenPackages, String packageOrFullClassName) {
        if (hiddenPackages != null && packageOrFullClassName != null) {
            for (String p : hiddenPackages) {
                if (p == null || !packageOrFullClassName.startsWith(p)) continue;
                packageOrFullClassName = Pattern.compile(p, 16).matcher(packageOrFullClassName).replaceFirst("");
                if (packageOrFullClassName.length() > 0 && packageOrFullClassName.charAt(0) == '.') {
                    packageOrFullClassName = packageOrFullClassName.substring(1);
                }
                return packageOrFullClassName;
            }
        }
        return packageOrFullClassName;
    }

    public static Class<?>[] getAllInterfaces(Object obj) {
        Class<?> c = obj.getClass();
        HashSet s = new HashSet();
        do {
            Class<?>[] its = c.getInterfaces();
            Collections.addAll(s, its);
        } while ((c = c.getSuperclass()) != null);
        return s.toArray(new Class[s.size()]);
    }

    private static void getMethodSig(StringBuilder sb, Method m) {
        sb.append(m.getName());
        sb.append(Type.getType((Method)m).getDescriptor());
    }

    public static String getMethodSig(Method m) {
        String sig = methodSigMap.get(m);
        if (sig != null) {
            return sig;
        }
        StringBuilder sb = new StringBuilder();
        ClassUtil.getMethodSig(sb, m);
        sig = sb.toString();
        methodSigMap.put(m, sig);
        return sig;
    }
}

