/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import com.alicp.jetcache.anno.method.CacheConfigUtil;
import com.alicp.jetcache.anno.method.CacheHandler;
import com.alicp.jetcache.anno.method.CacheInvokeConfig;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.support.CacheAnnoConfig;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ProxyUtil {
    public static <T> T getProxy(T target, CacheAnnoConfig cacheAnnoConfig, GlobalCacheConfig globalCacheConfig) {
        Class<?>[] its = ClassUtil.getAllInterfaces(target);
        CacheInvokeConfig cacheInvokeConfig = new CacheInvokeConfig();
        cacheInvokeConfig.setCacheAnnoConfig(cacheAnnoConfig);
        cacheInvokeConfig.init();
        CacheHandler h = new CacheHandler(target, cacheInvokeConfig, () -> globalCacheConfig.getCacheContext().createCacheInvokeContext(), globalCacheConfig.getHiddenPackages());
        Object o = Proxy.newProxyInstance(target.getClass().getClassLoader(), its, (InvocationHandler)h);
        return (T)o;
    }

    public static <T> T getProxyByAnnotation(T target, GlobalCacheConfig globalCacheConfig) {
        HashMap<String, CacheInvokeConfig> configMap = new HashMap<String, CacheInvokeConfig>();
        ProxyUtil.processType(configMap, target.getClass());
        Class<?>[] its = ClassUtil.getAllInterfaces(target);
        CacheHandler h = new CacheHandler(target, configMap, () -> globalCacheConfig.getCacheContext().createCacheInvokeContext(), globalCacheConfig.getHiddenPackages());
        Object o = Proxy.newProxyInstance(target.getClass().getClassLoader(), its, (InvocationHandler)h);
        return (T)o;
    }

    private static void processType(HashMap<String, CacheInvokeConfig> configMap, Class<?> clazz) {
        Class<?>[] interfaces;
        Method[] methods;
        if (clazz.isAnnotation() || clazz.isArray() || clazz.isEnum() || clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz.getName());
        }
        if (clazz.getName().startsWith("java")) {
            return;
        }
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            ProxyUtil.processMethod(configMap, m);
        }
        for (Class<?> it : interfaces = clazz.getInterfaces()) {
            ProxyUtil.processType(configMap, it);
        }
        if (!clazz.isInterface() && clazz.getSuperclass() != null) {
            ProxyUtil.processType(configMap, clazz.getSuperclass());
        }
    }

    private static void processMethod(HashMap<String, CacheInvokeConfig> configMap, Method m) {
        String sig = ClassUtil.getMethodSig(m);
        CacheInvokeConfig cac = configMap.get(sig);
        if (cac == null) {
            cac = new CacheInvokeConfig();
            if (CacheConfigUtil.parse(cac, m)) {
                configMap.put(sig, cac);
            }
        } else {
            CacheConfigUtil.parse(cac, m);
        }
    }
}

