/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.MultiLevelCacheBuilder;
import com.alicp.jetcache.RefreshCache;
import com.alicp.jetcache.anno.CacheType;
import com.alicp.jetcache.anno.method.CacheInvokeContext;
import com.alicp.jetcache.anno.method.ClassUtil;
import com.alicp.jetcache.anno.support.CacheAnnoConfig;
import com.alicp.jetcache.anno.support.CacheManager;
import com.alicp.jetcache.anno.support.CacheThreadLocal;
import com.alicp.jetcache.anno.support.ConfigProvider;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.embedded.EmbeddedCacheBuilder;
import com.alicp.jetcache.external.ExternalCacheBuilder;
import com.alicp.jetcache.support.DefaultCacheMonitor;
import com.alicp.jetcache.support.DefaultCacheMonitorManager;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class CacheContext {
    private static ThreadLocal<CacheThreadLocal> cacheThreadLocal = new ThreadLocal<CacheThreadLocal>(){

        @Override
        protected CacheThreadLocal initialValue() {
            return new CacheThreadLocal();
        }
    };
    private ConfigProvider configProvider = new ConfigProvider();
    private GlobalCacheConfig globalCacheConfig;
    private DefaultCacheMonitorManager defaultCacheMonitorManager;
    private CacheManager cacheManager;

    public CacheContext(GlobalCacheConfig globalCacheConfig) {
        this.globalCacheConfig = globalCacheConfig;
    }

    protected void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    @PostConstruct
    public synchronized void init() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager();
            if (this.globalCacheConfig.getStatIntervalMinutes() > 0) {
                this.defaultCacheMonitorManager = new DefaultCacheMonitorManager(this.globalCacheConfig.getStatIntervalMinutes(), TimeUnit.MINUTES, this.globalCacheConfig.getConfigProvider().statCallback());
                this.defaultCacheMonitorManager.start();
            }
        }
    }

    @PreDestroy
    public synchronized void shutdown() {
        if (this.defaultCacheMonitorManager != null) {
            this.defaultCacheMonitorManager.stop();
        }
        this.cacheManager = null;
        this.defaultCacheMonitorManager = null;
    }

    public CacheInvokeContext createCacheInvokeContext() {
        CacheInvokeContext c = this.newCacheInvokeContext();
        c.setCacheFunction(invokeContext -> {
            CacheAnnoConfig cacheAnnoConfig = invokeContext.getCacheInvokeConfig().getCacheAnnoConfig();
            String area = cacheAnnoConfig.getArea();
            String cacheName = cacheAnnoConfig.getName();
            if ("$$undefined$$".equalsIgnoreCase(cacheName)) {
                cacheName = ClassUtil.generateCacheName(invokeContext.getMethod(), invokeContext.getHiddenPackages());
            }
            String fullCacheName = area + "_" + cacheName;
            return this.__createOrGetCache(cacheAnnoConfig, area, fullCacheName);
        });
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache __createOrGetCache(CacheAnnoConfig cacheAnnoConfig, String area, String fullCacheName) {
        Cache cache = this.cacheManager.getCache(fullCacheName);
        if (cache == null) {
            CacheContext cacheContext = this;
            synchronized (cacheContext) {
                cache = this.cacheManager.getCache(fullCacheName);
                if (cache == null) {
                    cache = this.buildCache(cacheAnnoConfig, area, fullCacheName);
                    this.cacheManager.addCache(fullCacheName, cache);
                }
            }
        }
        return cache;
    }

    protected Cache buildCache(CacheAnnoConfig cacheAnnoConfig, String area, String fullCacheName) {
        Cache cache;
        if (cacheAnnoConfig.getCacheType() == CacheType.LOCAL) {
            cache = this.buildLocal(cacheAnnoConfig, area);
        } else if (cacheAnnoConfig.getCacheType() == CacheType.REMOTE) {
            cache = this.buildRemote(cacheAnnoConfig, area, fullCacheName);
        } else {
            Cache local = this.buildLocal(cacheAnnoConfig, area);
            Cache remote = this.buildRemote(cacheAnnoConfig, area, fullCacheName);
            if (this.defaultCacheMonitorManager != null) {
                DefaultCacheMonitor localMonitor = new DefaultCacheMonitor(fullCacheName + "_local");
                local.config().getMonitors().add(localMonitor);
                DefaultCacheMonitor remoteMonitor = new DefaultCacheMonitor(fullCacheName + "_remote");
                remote.config().getMonitors().add(remoteMonitor);
                this.defaultCacheMonitorManager.add(new DefaultCacheMonitor[]{localMonitor, remoteMonitor});
            }
            cache = ((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)((MultiLevelCacheBuilder.MultiLevelCacheBuilderImpl)MultiLevelCacheBuilder.createMultiLevelCacheBuilder().expireAfterWrite(local.config().getExpireAfterWriteInMillis(), TimeUnit.MILLISECONDS)).addCache(new Cache[]{local, remote})).buildCache();
        }
        cache = new RefreshCache(cache);
        if (this.defaultCacheMonitorManager != null) {
            DefaultCacheMonitor monitor = new DefaultCacheMonitor(fullCacheName);
            cache.config().getMonitors().add(monitor);
            this.defaultCacheMonitorManager.add(new DefaultCacheMonitor[]{monitor});
        }
        return cache;
    }

    protected Cache buildRemote(CacheAnnoConfig cacheAnnoConfig, String area, String cacheName) {
        ExternalCacheBuilder cacheBuilder = (ExternalCacheBuilder)this.globalCacheConfig.getRemoteCacheBuilders().get(area);
        if (cacheBuilder == null) {
            throw new CacheConfigException("no remote cache builder: " + area);
        }
        cacheBuilder = (ExternalCacheBuilder)cacheBuilder.clone();
        if (cacheAnnoConfig.getExpire() > 0L) {
            cacheBuilder.expireAfterWrite(cacheAnnoConfig.getExpire(), cacheAnnoConfig.getTimeUnit());
        }
        if (cacheBuilder.getConfig().getKeyPrefix() != null) {
            cacheBuilder.setKeyPrefix(cacheBuilder.getConfig().getKeyPrefix() + cacheName);
        } else {
            cacheBuilder.setKeyPrefix(cacheName);
        }
        if (!"$$undefined$$".equals(cacheAnnoConfig.getKeyConvertor())) {
            cacheBuilder.setKeyConvertor(this.configProvider.parseKeyConvertor(cacheAnnoConfig.getKeyConvertor()));
        }
        if (!"$$undefined$$".equals(cacheAnnoConfig.getSerialPolicy())) {
            cacheBuilder.setValueEncoder(this.configProvider.parseValueEncoder(cacheAnnoConfig.getSerialPolicy()));
            cacheBuilder.setValueDecoder(this.configProvider.parseValueDecoder(cacheAnnoConfig.getSerialPolicy()));
        }
        return cacheBuilder.buildCache();
    }

    protected Cache buildLocal(CacheAnnoConfig cacheAnnoConfig, String area) {
        EmbeddedCacheBuilder cacheBuilder = (EmbeddedCacheBuilder)this.globalCacheConfig.getLocalCacheBuilders().get(area);
        if (cacheBuilder == null) {
            throw new CacheConfigException("no local cache builder: " + area);
        }
        cacheBuilder = (EmbeddedCacheBuilder)cacheBuilder.clone();
        if (cacheAnnoConfig.getLocalLimit() != Integer.MIN_VALUE) {
            cacheBuilder.setLimit(cacheAnnoConfig.getLocalLimit());
        }
        if (cacheAnnoConfig.getExpire() > 0L) {
            cacheBuilder.expireAfterWrite(cacheAnnoConfig.getExpire(), cacheAnnoConfig.getTimeUnit());
        }
        if (!"$$undefined$$".equals(cacheAnnoConfig.getKeyConvertor())) {
            cacheBuilder.setKeyConvertor(this.configProvider.parseKeyConvertor(cacheAnnoConfig.getKeyConvertor()));
        }
        Cache cache = cacheBuilder.buildCache();
        return cache;
    }

    protected CacheInvokeContext newCacheInvokeContext() {
        return new CacheInvokeContext();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public static <T> T enableCache(Supplier<T> callback) {
        CacheThreadLocal var = cacheThreadLocal.get();
        try {
            var.setEnabledCount(var.getEnabledCount() + 1);
            T t = callback.get();
            return t;
        }
        finally {
            var.setEnabledCount(var.getEnabledCount() - 1);
        }
    }

    protected static void enable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() + 1);
    }

    protected static void disable() {
        CacheThreadLocal var = cacheThreadLocal.get();
        var.setEnabledCount(var.getEnabledCount() - 1);
    }

    protected static boolean isEnabled() {
        return cacheThreadLocal.get().getEnabledCount() > 0;
    }
}

