/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.anno.support.CacheContext;
import com.alicp.jetcache.anno.support.GlobalCacheConfig;
import com.alicp.jetcache.support.FastjsonKeyConvertor;
import com.alicp.jetcache.support.JavaValueDecoder;
import com.alicp.jetcache.support.JavaValueEncoder;
import com.alicp.jetcache.support.KryoValueDecoder;
import com.alicp.jetcache.support.KryoValueEncoder;
import com.alicp.jetcache.support.StatInfo;
import com.alicp.jetcache.support.StatInfoLogger;
import java.util.function.Consumer;
import java.util.function.Function;

public class ConfigProvider {
    public Function<Object, byte[]> parseValueEncoder(String valueEncoder) {
        if (valueEncoder == null) {
            throw new CacheConfigException("no serialPolicy");
        }
        if ("KRYO".equalsIgnoreCase(valueEncoder = valueEncoder.trim())) {
            return KryoValueEncoder.INSTANCE;
        }
        if ("JAVA".equalsIgnoreCase(valueEncoder)) {
            return JavaValueEncoder.INSTANCE;
        }
        throw new CacheConfigException("not supported:" + valueEncoder);
    }

    public Function<byte[], Object> parseValueDecoder(String valueDecoder) {
        if (valueDecoder == null) {
            throw new CacheConfigException("no serialPolicy");
        }
        if ("KRYO".equalsIgnoreCase(valueDecoder = valueDecoder.trim())) {
            return KryoValueDecoder.INSTANCE;
        }
        if ("JAVA".equalsIgnoreCase(valueDecoder)) {
            return JavaValueDecoder.INSTANCE;
        }
        throw new CacheConfigException("not supported:" + valueDecoder);
    }

    public Function<Object, Object> parseKeyConvertor(String convertor) {
        if (convertor == null) {
            return null;
        }
        if ("FASTJSON".equalsIgnoreCase(convertor)) {
            return FastjsonKeyConvertor.INSTANCE;
        }
        if ("NONE".equalsIgnoreCase(convertor)) {
            return null;
        }
        throw new CacheConfigException("not supported:" + convertor);
    }

    public CacheContext newContext(GlobalCacheConfig globalCacheConfig) {
        return new CacheContext(globalCacheConfig);
    }

    public Consumer<StatInfo> statCallback() {
        return new StatInfoLogger(false);
    }
}

