/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.support;

import com.alicp.jetcache.Cache;
import com.alicp.jetcache.anno.support.CacheManager;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(SimpleCacheManager.class);
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Cache>> caches = new ConcurrentHashMap();
    static SimpleCacheManager defaultManager = new SimpleCacheManager();

    public void rebuild() {
        this.caches.forEach((area, areaMap) -> areaMap.forEach((cacheName, cache) -> {
            try {
                cache.close();
            }
            catch (Exception e) {
                logger.error("error during close", (Throwable)e);
            }
        }));
        this.caches.clear();
    }

    private ConcurrentHashMap<String, Cache> getCachesByArea(String area) {
        return this.caches.computeIfAbsent(area, key -> new ConcurrentHashMap());
    }

    @Override
    public Cache getCache(String area, String cacheName) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        return areaMap.get(cacheName);
    }

    public void putCache(String area, String cacheName, Cache cache) {
        ConcurrentHashMap<String, Cache> areaMap = this.getCachesByArea(area);
        areaMap.put(cacheName, cache);
    }
}

