/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.Cache;
import com.alicp.jetcache.CacheConfig;
import com.alicp.jetcache.CacheGetResult;
import com.alicp.jetcache.CacheInvokeException;
import com.alicp.jetcache.CacheLoader;
import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.CacheUtil;
import com.alicp.jetcache.MultiGetResult;
import com.alicp.jetcache.ProxyCache;
import com.alicp.jetcache.SimpleProxyCache;
import com.alicp.jetcache.event.CacheEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class LoadingCache<K, V>
extends SimpleProxyCache<K, V> {
    protected Consumer<CacheEvent> eventConsumer;
    protected CacheConfig<K, V> config = this.config();

    public LoadingCache(Cache<K, V> cache) {
        super(cache);
        while (cache instanceof ProxyCache) {
            cache = ((ProxyCache)cache).getTargetCache();
        }
        if (cache instanceof AbstractCache) {
            this.eventConsumer = ((AbstractCache)cache)::notify;
        }
    }

    @Override
    public V get(K key) throws CacheInvokeException {
        CacheLoader<K, V> loader = this.config.getLoader();
        if (loader != null) {
            V loadedValue;
            CacheGetResult r;
            if (this.eventConsumer != null) {
                loader = CacheUtil.createProxyLoader(this.cache, loader, this.eventConsumer);
            }
            if ((r = this.GET(key)).isSuccess()) {
                return r.getValue();
            }
            try {
                loadedValue = loader.load(key);
            }
            catch (Throwable e) {
                throw new CacheInvokeException(e);
            }
            if (loadedValue != null || this.config.isCacheNullValue()) {
                this.PUT(key, loadedValue);
            }
            return loadedValue;
        }
        return this.cache.get(key);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) throws CacheInvokeException {
        CacheLoader loader = this.config.getLoader();
        if (loader != null) {
            Map<K, V> loadResult;
            MultiGetResult r;
            if (this.eventConsumer != null) {
                loader = CacheUtil.createProxyLoader(this.cache, loader, this.eventConsumer);
            }
            Map kvMap = (r = this.GET_ALL(keys)).isSuccess() || r.getResultCode() == CacheResultCode.PART_SUCCESS ? r.unwrapValues() : new HashMap();
            HashSet keysNeedLoad = new HashSet();
            keys.forEach(k -> {
                if (!kvMap.containsKey(k)) {
                    keysNeedLoad.add(k);
                }
            });
            try {
                loadResult = loader.loadAll(keysNeedLoad);
                for (Map.Entry<K, V> en : loadResult.entrySet()) {
                    K key = en.getKey();
                    V loadedValue = en.getValue();
                    if (loadedValue == null && !this.config.isCacheNullValue()) continue;
                    this.PUT(key, loadedValue);
                }
            }
            catch (Throwable e) {
                throw new CacheInvokeException(e);
            }
            kvMap.putAll(loadResult);
            return kvMap;
        }
        return this.cache.getAll(keys);
    }
}

