/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.external;

import com.alicp.jetcache.AbstractCache;
import com.alicp.jetcache.CacheConfigException;
import com.alicp.jetcache.CacheException;
import com.alicp.jetcache.external.ExternalCacheConfig;
import com.alicp.jetcache.external.ExternalKeyUtil;
import java.io.IOException;

public abstract class AbstractExternalCache<K, V>
extends AbstractCache<K, V> {
    private ExternalCacheConfig<K, V> config;

    public AbstractExternalCache(ExternalCacheConfig<K, V> config) {
        this.config = config;
        if (config.getValueEncoder() == null) {
            throw new CacheConfigException("no value encoder");
        }
        if (config.getValueDecoder() == null) {
            throw new CacheConfigException("no value decoder");
        }
    }

    public byte[] buildKey(K key) {
        try {
            Object newKey = key;
            if (key instanceof byte[]) {
                newKey = key;
            } else if (key instanceof String) {
                newKey = key;
            } else if (this.config.getKeyConvertor() != null) {
                newKey = this.config.getKeyConvertor().apply(key);
            }
            return ExternalKeyUtil.buildKeyAfterConvert(newKey, this.config.getKeyPrefix());
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }
}

