/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.common.auth;

import com.alibaba.sdk.android.oss.ClientException;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationCredentialProvider;
import com.alibaba.sdk.android.oss.common.auth.OSSFederationToken;
import com.alibaba.sdk.android.oss.common.utils.IOUtils;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class OSSAuthCredentialsProvider
extends OSSFederationCredentialProvider {
    private String mAuthServerUrl;
    private AuthDecoder mDecoder;

    public OSSAuthCredentialsProvider(String authServerUrl) {
        this.mAuthServerUrl = authServerUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.mAuthServerUrl = authServerUrl;
    }

    public void setDecoder(AuthDecoder decoder) {
        this.mDecoder = decoder;
    }

    @Override
    public OSSFederationToken getFederationToken() throws ClientException {
        try {
            JSONObject jsonObj;
            int statusCode;
            URL stsUrl = new URL(this.mAuthServerUrl);
            HttpURLConnection conn = (HttpURLConnection)stsUrl.openConnection();
            conn.setConnectTimeout(10000);
            InputStream input = conn.getInputStream();
            String authData = IOUtils.readStreamAsString(input, "utf-8");
            if (this.mDecoder != null) {
                authData = this.mDecoder.decode(authData);
            }
            if ((statusCode = (jsonObj = new JSONObject(authData)).getInt("StatusCode")) != 200) {
                String errorCode = jsonObj.getString("ErrorCode");
                String errorMessage = jsonObj.getString("ErrorMessage");
                throw new ClientException("ErrorCode: " + errorCode + "| ErrorMessage: " + errorMessage);
            }
            String ak = jsonObj.getString("AccessKeyId");
            String sk = jsonObj.getString("AccessKeySecret");
            String token = jsonObj.getString("SecurityToken");
            String expiration = jsonObj.getString("Expiration");
            OSSFederationToken authToken = new OSSFederationToken(ak, sk, token, expiration);
            return authToken;
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    public static interface AuthDecoder {
        public String decode(String var1);
    }
}

