/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.oss.internal;

import com.alibaba.sdk.android.oss.common.utils.OSSUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class CheckCRC64DownloadInputStream
extends CheckedInputStream {
    private long mTotalBytesRead;
    private long mTotalLength;
    private long mServerCRC64;
    private String mRequestId;
    private long mClientCRC64;

    public CheckCRC64DownloadInputStream(InputStream is, Checksum csum, long total, long serverCRC64, String requestId) {
        super(is, csum);
        this.mTotalLength = total;
        this.mServerCRC64 = serverCRC64;
        this.mRequestId = requestId;
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        this.checkCRC64(read);
        return read;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int read = super.read(buffer, byteOffset, byteCount);
        this.checkCRC64(read);
        return read;
    }

    private void checkCRC64(int byteRead) throws IOException {
        this.mTotalBytesRead += (long)byteRead;
        if (this.mTotalBytesRead >= this.mTotalLength) {
            this.mClientCRC64 = this.getChecksum().getValue();
            OSSUtils.checkChecksum(this.mClientCRC64, this.mServerCRC64, this.mRequestId);
        }
    }

    public long getClientCRC64() {
        return this.mClientCRC64;
    }
}

