/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidentityprovider.model.ResourceServerScopeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateResourceServerRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String userPoolId;
    private String identifier;
    private String name;
    private List<ResourceServerScopeType> scopes;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public CreateResourceServerRequest withUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public CreateResourceServerRequest withIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateResourceServerRequest withName(String name) {
        this.name = name;
        return this;
    }

    public List<ResourceServerScopeType> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<ResourceServerScopeType> scopes) {
        if (scopes == null) {
            this.scopes = null;
            return;
        }
        this.scopes = new ArrayList<ResourceServerScopeType>(scopes);
    }

    public CreateResourceServerRequest withScopes(ResourceServerScopeType ... scopes) {
        if (this.getScopes() == null) {
            this.scopes = new ArrayList<ResourceServerScopeType>(scopes.length);
        }
        for (ResourceServerScopeType value : scopes) {
            this.scopes.add(value);
        }
        return this;
    }

    public CreateResourceServerRequest withScopes(Collection<ResourceServerScopeType> scopes) {
        this.setScopes(scopes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: " + this.getUserPoolId() + ",");
        }
        if (this.getIdentifier() != null) {
            sb.append("Identifier: " + this.getIdentifier() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getScopes() != null) {
            sb.append("Scopes: " + this.getScopes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScopes() == null ? 0 : this.getScopes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceServerRequest)) {
            return false;
        }
        CreateResourceServerRequest other = (CreateResourceServerRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getIdentifier() == null ^ this.getIdentifier() == null) {
            return false;
        }
        if (other.getIdentifier() != null && !other.getIdentifier().equals(this.getIdentifier())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScopes() == null ^ this.getScopes() == null) {
            return false;
        }
        return other.getScopes() == null || other.getScopes().equals(this.getScopes());
    }
}

