/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentityprovider.model.transform;

import com.amazonaws.services.cognitoidentityprovider.model.AnalyticsConfigurationType;
import com.amazonaws.services.cognitoidentityprovider.model.TokenValidityUnitsType;
import com.amazonaws.services.cognitoidentityprovider.model.UserPoolClientType;
import com.amazonaws.services.cognitoidentityprovider.model.transform.AnalyticsConfigurationTypeJsonMarshaller;
import com.amazonaws.services.cognitoidentityprovider.model.transform.TokenValidityUnitsTypeJsonMarshaller;
import com.amazonaws.util.json.AwsJsonWriter;
import java.util.Date;
import java.util.List;

class UserPoolClientTypeJsonMarshaller {
    private static UserPoolClientTypeJsonMarshaller instance;

    UserPoolClientTypeJsonMarshaller() {
    }

    public void marshall(UserPoolClientType userPoolClientType, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (userPoolClientType.getUserPoolId() != null) {
            String userPoolId = userPoolClientType.getUserPoolId();
            jsonWriter.name("UserPoolId");
            jsonWriter.value(userPoolId);
        }
        if (userPoolClientType.getClientName() != null) {
            String clientName = userPoolClientType.getClientName();
            jsonWriter.name("ClientName");
            jsonWriter.value(clientName);
        }
        if (userPoolClientType.getClientId() != null) {
            String clientId = userPoolClientType.getClientId();
            jsonWriter.name("ClientId");
            jsonWriter.value(clientId);
        }
        if (userPoolClientType.getClientSecret() != null) {
            String clientSecret = userPoolClientType.getClientSecret();
            jsonWriter.name("ClientSecret");
            jsonWriter.value(clientSecret);
        }
        if (userPoolClientType.getLastModifiedDate() != null) {
            Date lastModifiedDate = userPoolClientType.getLastModifiedDate();
            jsonWriter.name("LastModifiedDate");
            jsonWriter.value(lastModifiedDate);
        }
        if (userPoolClientType.getCreationDate() != null) {
            Date creationDate = userPoolClientType.getCreationDate();
            jsonWriter.name("CreationDate");
            jsonWriter.value(creationDate);
        }
        if (userPoolClientType.getRefreshTokenValidity() != null) {
            Integer refreshTokenValidity = userPoolClientType.getRefreshTokenValidity();
            jsonWriter.name("RefreshTokenValidity");
            jsonWriter.value((Number)refreshTokenValidity);
        }
        if (userPoolClientType.getAccessTokenValidity() != null) {
            Integer accessTokenValidity = userPoolClientType.getAccessTokenValidity();
            jsonWriter.name("AccessTokenValidity");
            jsonWriter.value((Number)accessTokenValidity);
        }
        if (userPoolClientType.getIdTokenValidity() != null) {
            Integer idTokenValidity = userPoolClientType.getIdTokenValidity();
            jsonWriter.name("IdTokenValidity");
            jsonWriter.value((Number)idTokenValidity);
        }
        if (userPoolClientType.getTokenValidityUnits() != null) {
            TokenValidityUnitsType tokenValidityUnits = userPoolClientType.getTokenValidityUnits();
            jsonWriter.name("TokenValidityUnits");
            TokenValidityUnitsTypeJsonMarshaller.getInstance().marshall(tokenValidityUnits, jsonWriter);
        }
        if (userPoolClientType.getReadAttributes() != null) {
            List<String> readAttributes = userPoolClientType.getReadAttributes();
            jsonWriter.name("ReadAttributes");
            jsonWriter.beginArray();
            for (String readAttributesItem : readAttributes) {
                if (readAttributesItem == null) continue;
                jsonWriter.value(readAttributesItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getWriteAttributes() != null) {
            List<String> writeAttributes = userPoolClientType.getWriteAttributes();
            jsonWriter.name("WriteAttributes");
            jsonWriter.beginArray();
            for (String writeAttributesItem : writeAttributes) {
                if (writeAttributesItem == null) continue;
                jsonWriter.value(writeAttributesItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getExplicitAuthFlows() != null) {
            List<String> explicitAuthFlows = userPoolClientType.getExplicitAuthFlows();
            jsonWriter.name("ExplicitAuthFlows");
            jsonWriter.beginArray();
            for (String explicitAuthFlowsItem : explicitAuthFlows) {
                if (explicitAuthFlowsItem == null) continue;
                jsonWriter.value(explicitAuthFlowsItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getSupportedIdentityProviders() != null) {
            List<String> supportedIdentityProviders = userPoolClientType.getSupportedIdentityProviders();
            jsonWriter.name("SupportedIdentityProviders");
            jsonWriter.beginArray();
            for (String supportedIdentityProvidersItem : supportedIdentityProviders) {
                if (supportedIdentityProvidersItem == null) continue;
                jsonWriter.value(supportedIdentityProvidersItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getCallbackURLs() != null) {
            List<String> callbackURLs = userPoolClientType.getCallbackURLs();
            jsonWriter.name("CallbackURLs");
            jsonWriter.beginArray();
            for (String callbackURLsItem : callbackURLs) {
                if (callbackURLsItem == null) continue;
                jsonWriter.value(callbackURLsItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getLogoutURLs() != null) {
            List<String> logoutURLs = userPoolClientType.getLogoutURLs();
            jsonWriter.name("LogoutURLs");
            jsonWriter.beginArray();
            for (String logoutURLsItem : logoutURLs) {
                if (logoutURLsItem == null) continue;
                jsonWriter.value(logoutURLsItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getDefaultRedirectURI() != null) {
            String defaultRedirectURI = userPoolClientType.getDefaultRedirectURI();
            jsonWriter.name("DefaultRedirectURI");
            jsonWriter.value(defaultRedirectURI);
        }
        if (userPoolClientType.getAllowedOAuthFlows() != null) {
            List<String> allowedOAuthFlows = userPoolClientType.getAllowedOAuthFlows();
            jsonWriter.name("AllowedOAuthFlows");
            jsonWriter.beginArray();
            for (String allowedOAuthFlowsItem : allowedOAuthFlows) {
                if (allowedOAuthFlowsItem == null) continue;
                jsonWriter.value(allowedOAuthFlowsItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getAllowedOAuthScopes() != null) {
            List<String> allowedOAuthScopes = userPoolClientType.getAllowedOAuthScopes();
            jsonWriter.name("AllowedOAuthScopes");
            jsonWriter.beginArray();
            for (String allowedOAuthScopesItem : allowedOAuthScopes) {
                if (allowedOAuthScopesItem == null) continue;
                jsonWriter.value(allowedOAuthScopesItem);
            }
            jsonWriter.endArray();
        }
        if (userPoolClientType.getAllowedOAuthFlowsUserPoolClient() != null) {
            Boolean allowedOAuthFlowsUserPoolClient = userPoolClientType.getAllowedOAuthFlowsUserPoolClient();
            jsonWriter.name("AllowedOAuthFlowsUserPoolClient");
            jsonWriter.value(allowedOAuthFlowsUserPoolClient.booleanValue());
        }
        if (userPoolClientType.getAnalyticsConfiguration() != null) {
            AnalyticsConfigurationType analyticsConfiguration = userPoolClientType.getAnalyticsConfiguration();
            jsonWriter.name("AnalyticsConfiguration");
            AnalyticsConfigurationTypeJsonMarshaller.getInstance().marshall(analyticsConfiguration, jsonWriter);
        }
        if (userPoolClientType.getPreventUserExistenceErrors() != null) {
            String preventUserExistenceErrors = userPoolClientType.getPreventUserExistenceErrors();
            jsonWriter.name("PreventUserExistenceErrors");
            jsonWriter.value(preventUserExistenceErrors);
        }
        if (userPoolClientType.getEnableTokenRevocation() != null) {
            Boolean enableTokenRevocation = userPoolClientType.getEnableTokenRevocation();
            jsonWriter.name("EnableTokenRevocation");
            jsonWriter.value(enableTokenRevocation.booleanValue());
        }
        if (userPoolClientType.getEnablePropagateAdditionalUserContextData() != null) {
            Boolean enablePropagateAdditionalUserContextData = userPoolClientType.getEnablePropagateAdditionalUserContextData();
            jsonWriter.name("EnablePropagateAdditionalUserContextData");
            jsonWriter.value(enablePropagateAdditionalUserContextData.booleanValue());
        }
        jsonWriter.endObject();
    }

    public static UserPoolClientTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UserPoolClientTypeJsonMarshaller();
        }
        return instance;
    }
}

