/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.policy.internal;

import com.amazonaws.auth.policy.Action;
import com.amazonaws.auth.policy.Condition;
import com.amazonaws.auth.policy.Policy;
import com.amazonaws.auth.policy.Principal;
import com.amazonaws.auth.policy.Resource;
import com.amazonaws.auth.policy.Statement;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonPolicyWriter {
    private AwsJsonWriter jsonWriter = null;
    private final Writer writer = new StringWriter();
    private static final Log log = LogFactory.getLog("com.amazonaws.auth.policy");

    public JsonPolicyWriter() {
        this.jsonWriter = JsonUtils.getJsonWriter(this.writer);
    }

    public String writePolicyToString(Policy policy) {
        if (!this.isNotNull(policy)) {
            throw new IllegalArgumentException("Policy cannot be null");
        }
        try {
            String string = this.jsonStringOf(policy);
            return string;
        }
        catch (Exception e) {
            String message = "Unable to serialize policy to JSON string: " + e.getMessage();
            throw new IllegalArgumentException(message, e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {}
        }
    }

    private String jsonStringOf(Policy policy) throws IOException {
        this.jsonWriter.beginObject();
        this.writeJsonKeyValue("Version", policy.getVersion());
        if (this.isNotNull(policy.getId())) {
            this.writeJsonKeyValue("Id", policy.getId());
        }
        this.writeJsonArrayStart("Statement");
        for (Statement statement : policy.getStatements()) {
            List<Condition> conditions;
            List<Resource> resources;
            List<Action> actions;
            this.jsonWriter.beginObject();
            if (this.isNotNull(statement.getId())) {
                this.writeJsonKeyValue("Sid", statement.getId());
            }
            this.writeJsonKeyValue("Effect", statement.getEffect().toString());
            List<Principal> principals = statement.getPrincipals();
            if (this.isNotNull(principals) && !principals.isEmpty()) {
                this.writePrincipals(principals);
            }
            if (this.isNotNull(actions = statement.getActions()) && !actions.isEmpty()) {
                this.writeActions(actions);
            }
            if (this.isNotNull(resources = statement.getResources()) && !resources.isEmpty()) {
                this.writeResources(resources);
            }
            if (this.isNotNull(conditions = statement.getConditions()) && !conditions.isEmpty()) {
                this.writeConditions(conditions);
            }
            this.jsonWriter.endObject();
        }
        this.writeJsonArrayEnd();
        this.jsonWriter.endObject();
        this.jsonWriter.flush();
        return this.writer.toString();
    }

    private void writeConditions(List<Condition> conditions) throws IOException {
        Map<String, ConditionsByKey> conditionsByType = this.groupConditionsByTypeAndKey(conditions);
        this.writeJsonObjectStart("Condition");
        for (Map.Entry<String, ConditionsByKey> entry : conditionsByType.entrySet()) {
            ConditionsByKey conditionsByKey = conditionsByType.get(entry.getKey());
            this.writeJsonObjectStart(entry.getKey());
            for (String key : conditionsByKey.keySet()) {
                this.writeJsonArray(key, conditionsByKey.getConditionsByKey(key));
            }
            this.writeJsonObjectEnd();
        }
        this.writeJsonObjectEnd();
    }

    private void writeResources(List<Resource> resources) throws IOException {
        ArrayList<String> resourceStrings = new ArrayList<String>();
        for (Resource resource : resources) {
            resourceStrings.add(resource.getId());
        }
        this.writeJsonArray("Resource", resourceStrings);
    }

    private void writeActions(List<Action> actions) throws IOException {
        ArrayList<String> actionStrings = new ArrayList<String>();
        for (Action action : actions) {
            actionStrings.add(action.getActionName());
        }
        this.writeJsonArray("Action", actionStrings);
    }

    private void writePrincipals(List<Principal> principals) throws IOException {
        if (principals.size() == 1 && principals.get(0).equals(Principal.All)) {
            this.writeJsonKeyValue("Principal", Principal.All.getId());
        } else {
            this.writeJsonObjectStart("Principal");
            Map<String, List<String>> principalsByScheme = this.groupPrincipalByScheme(principals);
            for (Map.Entry<String, List<String>> entry : principalsByScheme.entrySet()) {
                List<String> principalValues = principalsByScheme.get(entry.getKey());
                if (principalValues.size() == 1) {
                    this.writeJsonKeyValue(entry.getKey(), principalValues.get(0));
                    continue;
                }
                this.writeJsonArray(entry.getKey(), principalValues);
            }
            this.writeJsonObjectEnd();
        }
    }

    private Map<String, List<String>> groupPrincipalByScheme(List<Principal> principals) {
        HashMap<String, List<String>> principalsByScheme = new HashMap<String, List<String>>();
        for (Principal principal : principals) {
            String provider = principal.getProvider();
            if (!principalsByScheme.containsKey(provider)) {
                principalsByScheme.put(provider, new ArrayList());
            }
            List principalValues = (List)principalsByScheme.get(provider);
            principalValues.add(principal.getId());
        }
        return principalsByScheme;
    }

    private Map<String, ConditionsByKey> groupConditionsByTypeAndKey(List<Condition> conditions) {
        HashMap<String, ConditionsByKey> conditionsByType = new HashMap<String, ConditionsByKey>();
        for (Condition condition : conditions) {
            String type = condition.getType();
            String key = condition.getConditionKey();
            if (!conditionsByType.containsKey(type)) {
                conditionsByType.put(type, new ConditionsByKey());
            }
            ConditionsByKey conditionsByKey = (ConditionsByKey)conditionsByType.get(type);
            conditionsByKey.addValuesToKey(key, condition.getValues());
        }
        return conditionsByType;
    }

    private void writeJsonArray(String arrayName, List<String> values) throws IOException {
        this.writeJsonArrayStart(arrayName);
        for (String value : values) {
            this.jsonWriter.value(value);
        }
        this.writeJsonArrayEnd();
    }

    private void writeJsonObjectStart(String fieldName) throws IOException {
        this.jsonWriter.name(fieldName);
        this.jsonWriter.beginObject();
    }

    private void writeJsonObjectEnd() throws IOException {
        this.jsonWriter.endObject();
    }

    private void writeJsonArrayStart(String fieldName) throws IOException {
        this.jsonWriter.name(fieldName);
        this.jsonWriter.beginArray();
    }

    private void writeJsonArrayEnd() throws IOException {
        this.jsonWriter.endArray();
    }

    private void writeJsonKeyValue(String fieldName, String value) throws IOException {
        this.jsonWriter.name(fieldName);
        this.jsonWriter.value(value);
    }

    private boolean isNotNull(Object object) {
        return null != object;
    }

    static class ConditionsByKey {
        private Map<String, List<String>> conditionsByKey = new HashMap<String, List<String>>();

        public Map<String, List<String>> getConditionsByKey() {
            return this.conditionsByKey;
        }

        public void setConditionsByKey(Map<String, List<String>> conditionsByKey) {
            this.conditionsByKey = conditionsByKey;
        }

        public boolean containsKey(String key) {
            return this.conditionsByKey.containsKey(key);
        }

        public List<String> getConditionsByKey(String key) {
            return this.conditionsByKey.get(key);
        }

        public Set<String> keySet() {
            return this.conditionsByKey.keySet();
        }

        public void addValuesToKey(String key, List<String> values) {
            List<String> conditionValues = this.getConditionsByKey(key);
            if (conditionValues == null) {
                this.conditionsByKey.put(key, new ArrayList<String>(values));
            } else {
                conditionValues.addAll(values);
            }
        }
    }
}

