/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.internal;

import com.amazonaws.AbortedException;
import com.amazonaws.internal.MetricAware;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.util.SdkRuntime;
import java.io.IOException;
import java.io.InputStream;

public abstract class SdkInputStream
extends InputStream
implements MetricAware {
    protected abstract InputStream getWrappedInputStream();

    @Override
    public final boolean isMetricActivated() {
        InputStream in = this.getWrappedInputStream();
        if (in instanceof MetricAware) {
            MetricAware metricAware = (MetricAware)((Object)in);
            return metricAware.isMetricActivated();
        }
        return false;
    }

    protected final void abortIfNeeded() {
        if (SdkRuntime.shouldAbort()) {
            try {
                this.abort();
            }
            catch (IOException e) {
                LogFactory.getLog(this.getClass()).debug("FYI", e);
            }
            throw new AbortedException();
        }
    }

    protected void abort() throws IOException {
    }
}

