/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.message;

import com.amazonaws.org.apache.http.HeaderElement;
import com.amazonaws.org.apache.http.NameValuePair;
import com.amazonaws.org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueFormatter {
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();

    public CharArrayBuffer formatHeaderElement(CharArrayBuffer buffer, HeaderElement elem, boolean quote) {
        int parcnt;
        if (elem == null) {
            throw new IllegalArgumentException("Header element must not be null.");
        }
        int len = this.estimateHeaderElementLen(elem);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer.append("; ");
                this.formatNameValuePair(buffer, elem.getParameter(i), quote);
            }
        }
        return buffer;
    }

    protected int estimateHeaderElementLen(HeaderElement elem) {
        int parcnt;
        if (elem == null) {
            return 0;
        }
        int result = elem.getName().length();
        String value = elem.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result += 2 + this.estimateNameValuePairLen(elem.getParameter(i));
            }
        }
        return result;
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer buffer, NameValuePair nvp, boolean quote) {
        if (nvp == null) {
            throw new IllegalArgumentException("NameValuePair must not be null.");
        }
        int len = this.estimateNameValuePairLen(nvp);
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        return buffer;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result = nvp.getName().length();
        String value = nvp.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        return result;
    }

    protected void doFormatValue(CharArrayBuffer buffer, String value, boolean quote) {
        int i;
        if (!quote) {
            for (i = 0; i < value.length() && !quote; ++i) {
                quote = this.isSeparator(value.charAt(i));
            }
        }
        if (quote) {
            buffer.append('\"');
        }
        for (i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer.append('\\');
            }
            buffer.append(ch);
        }
        if (quote) {
            buffer.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return " ;,:@()<>\\\"/[]?={}\t".indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return "\"\\".indexOf(ch) >= 0;
    }
}

