/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AbstractAWSSigner;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.SignatureVersion;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;

public class QueryStringSigner
extends AbstractAWSSigner
implements Signer {
    private Date overriddenDate;

    @Override
    public void sign(Request<?> request, AWSCredentials aWSCredentials) throws AmazonClientException {
        this.sign(request, SignatureVersion.V2, SigningAlgorithm.HmacSHA256, aWSCredentials);
    }

    public void sign(Request<?> request, SignatureVersion signatureVersion, SigningAlgorithm signingAlgorithm, AWSCredentials aWSCredentials) throws AmazonClientException {
        if (aWSCredentials instanceof AnonymousAWSCredentials) {
            return;
        }
        AWSCredentials aWSCredentials2 = this.sanitizeCredentials(aWSCredentials);
        request.addParameter("AWSAccessKeyId", aWSCredentials2.getAWSAccessKeyId());
        request.addParameter("SignatureVersion", signatureVersion.toString());
        int n = this.getTimeOffset(request);
        request.addParameter("Timestamp", this.getFormattedTimestamp(n));
        if (aWSCredentials2 instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)aWSCredentials2);
        }
        String string = null;
        if (signatureVersion.equals((Object)SignatureVersion.V1)) {
            string = this.calculateStringToSignV1(request.getParameters());
        } else if (signatureVersion.equals((Object)SignatureVersion.V2)) {
            request.addParameter("SignatureMethod", signingAlgorithm.toString());
            string = this.calculateStringToSignV2(request);
        } else {
            throw new AmazonClientException("Invalid Signature Version specified");
        }
        String string2 = this.signAndBase64Encode(string, aWSCredentials2.getAWSSecretKey(), signingAlgorithm);
        request.addParameter("Signature", string2);
    }

    private String calculateStringToSignV1(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(map);
        for (Map.Entry entry : treeMap.entrySet()) {
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append((String)entry.getValue());
        }
        return stringBuilder.toString();
    }

    private String calculateStringToSignV2(Request<?> request) throws AmazonClientException {
        URI uRI = request.getEndpoint();
        Map<String, String> map = request.getParameters();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("POST").append("\n");
        stringBuilder.append(this.getCanonicalizedEndpoint(uRI)).append("\n");
        stringBuilder.append(this.getCanonicalizedResourcePath(request)).append("\n");
        stringBuilder.append(this.getCanonicalizedQueryString(map));
        return stringBuilder.toString();
    }

    private String getCanonicalizedResourcePath(Request<?> request) {
        String string = "";
        if (request.getEndpoint().getPath() != null) {
            string = string + request.getEndpoint().getPath();
        }
        if (request.getResourcePath() != null) {
            if (string.length() > 0 && !string.endsWith("/") && !request.getResourcePath().startsWith("/")) {
                string = string + "/";
            }
            string = string + request.getResourcePath();
        } else if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.startsWith("//")) {
            string = string.substring(1);
        }
        return string;
    }

    private String getFormattedTimestamp(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.overriddenDate != null) {
            return simpleDateFormat.format(this.overriddenDate);
        }
        return simpleDateFormat.format(this.getSignatureDate(n));
    }

    void overrideDate(Date date) {
        this.overriddenDate = date;
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials aWSSessionCredentials) {
        request.addParameter("SecurityToken", aWSSessionCredentials.getSessionToken());
    }
}

