/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Date;

public class STSAssumeRoleSessionCredentialsProvider
implements AWSCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 900;
    private static final int EXPIRY_TIME_MILLIS = 60000;
    private final AWSSecurityTokenService securityTokenService;
    private AWSSessionCredentials sessionCredentials;
    private Date sessionCredentialsExpiration;
    private String roleArn;
    private String roleSessionName;

    public STSAssumeRoleSessionCredentialsProvider(String string, String string2) {
        this.roleArn = string;
        this.roleSessionName = string2;
        this.securityTokenService = new AWSSecurityTokenServiceClient();
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials aWSCredentials, String string, String string2) {
        this(aWSCredentials, string, string2, new ClientConfiguration());
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials aWSCredentials, String string, String string2, ClientConfiguration clientConfiguration) {
        this.roleArn = string;
        this.roleSessionName = string2;
        this.securityTokenService = new AWSSecurityTokenServiceClient(aWSCredentials, clientConfiguration);
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider, String string, String string2) {
        this.roleArn = string;
        this.roleSessionName = string2;
        this.securityTokenService = new AWSSecurityTokenServiceClient(aWSCredentialsProvider);
    }

    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider aWSCredentialsProvider, String string, String string2, ClientConfiguration clientConfiguration) {
        this.roleArn = string;
        this.roleSessionName = string2;
        this.securityTokenService = new AWSSecurityTokenServiceClient(aWSCredentialsProvider, clientConfiguration);
    }

    @Override
    public AWSCredentials getCredentials() {
        if (this.needsNewSession()) {
            this.startSession();
        }
        return this.sessionCredentials;
    }

    @Override
    public void refresh() {
        this.startSession();
    }

    private void startSession() {
        AssumeRoleResult assumeRoleResult = this.securityTokenService.assumeRole(new AssumeRoleRequest().withRoleArn(this.roleArn).withDurationSeconds(900).withRoleSessionName(this.roleSessionName));
        Credentials credentials = assumeRoleResult.getCredentials();
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    private boolean needsNewSession() {
        if (this.sessionCredentials == null) {
            return true;
        }
        long l = this.sessionCredentialsExpiration.getTime() - System.currentTimeMillis();
        return l < 60000L;
    }
}

