/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.profile.internal.Profile;
import com.amazonaws.auth.profile.internal.ProfilesConfigFileLoader;
import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProfilesConfigFile {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFile.class);
    @Deprecated
    private static final String LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE = "AWS_CONFIG_FILE";
    private static final String CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE = "AWS_CREDENTIAL_PROFILES_FILE";
    @Deprecated
    private static final String LEGACY_CONFIG_PROFILES_FILENAME = "config";
    private static final String DEFAULT_CREDENTIAL_PROFILES_FILENAME = "credentials";
    public static final String DEFAULT_PROFILE_NAME = "default";
    private Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();

    public ProfilesConfigFile() throws AmazonClientException {
        this(ProfilesConfigFile.getCredentialProfilesFile());
    }

    public ProfilesConfigFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Unable to load AWS profiles: specified file path is null.");
        }
        this.loadProfiles(new File(string));
    }

    public ProfilesConfigFile(File file) throws AmazonClientException {
        this.loadProfiles(file);
    }

    public AWSCredentials getCredentials(String string) {
        if (this.profilesByName.get(string) == null) {
            throw new IllegalArgumentException("No AWS profile named '" + string + "'");
        }
        return this.profilesByName.get(string).getCredentials();
    }

    public Map<String, Profile> getAllProfiles() {
        return new LinkedHashMap<String, Profile>(this.profilesByName);
    }

    private static File getCredentialProfilesFile() {
        boolean bl;
        String string;
        String string2 = System.getenv(CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE);
        if (string2 == null && (string = System.getenv(LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE)) != null) {
            LOG.warn(String.format("Found the legacy environment variable [%s=%s]. Please use the latest environment variable to specify your credentials file override: [%s=%s]", LEGACY_CONFIG_FILE_ENVIRONMENT_VARIABLE, string, CREDENTIAL_PROFILES_FILE_ENVIRONMENT_VARIABLE, string));
        }
        if (string2 != null) {
            LOG.debug("Loading AWS credential profiles from overridden file: " + string2);
            return new File(string2);
        }
        string = System.getProperty("user.home");
        if (string == null) {
            throw new AmazonClientException("Unable to load AWS profiles: 'user.home' System property is not set.");
        }
        File file = new File(string, ".aws");
        File file2 = new File(file, DEFAULT_CREDENTIAL_PROFILES_FILENAME);
        File file3 = new File(file, LEGACY_CONFIG_PROFILES_FILENAME);
        boolean bl2 = file2.exists() && file2.isFile();
        boolean bl3 = bl = file3.exists() && file3.isFile();
        if (!bl2 && bl) {
            LOG.warn("Found the legacy config profiles file at [" + file3.getAbsolutePath() + "]. Please move it to the latest default location [" + file2 + "].");
            return file3;
        }
        return file2;
    }

    private void loadProfiles(File file) {
        this.profilesByName.putAll(ProfilesConfigFileLoader.loadProfiles(file));
    }
}

