/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.core.base;

import com.amazonaws.com.fasterxml.jackson.core.Base64Variant;
import com.amazonaws.com.fasterxml.jackson.core.JsonParseException;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.io.NumberInput;
import com.amazonaws.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.IOException;

public abstract class ParserMinimalBase
extends JsonParser {
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int features) {
        super(features);
    }

    @Override
    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public JsonToken nextValue() throws IOException, JsonParseException {
        JsonToken t = this.nextToken();
        if (t == JsonToken.FIELD_NAME) {
            t = this.nextToken();
        }
        return t;
    }

    @Override
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            switch (t) {
                case START_OBJECT: 
                case START_ARRAY: {
                    ++open;
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    if (--open != 0) break;
                    return this;
                }
            }
        }
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public abstract String getText() throws IOException, JsonParseException;

    @Override
    public int getValueAsInt(int defaultValue) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getIntValue();
                }
                case VALUE_TRUE: {
                    return 1;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsInt(this.getText(), defaultValue);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).intValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public long getValueAsLong(long defaultValue) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (this._currToken) {
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return this.getLongValue();
                }
                case VALUE_TRUE: {
                    return 1L;
                }
                case VALUE_FALSE: 
                case VALUE_NULL: {
                    return 0L;
                }
                case VALUE_STRING: {
                    return NumberInput.parseAsLong(this.getText(), defaultValue);
                }
                case VALUE_EMBEDDED_OBJECT: {
                    Object value = this.getEmbeddedObject();
                    if (!(value instanceof Number)) break;
                    return ((Number)value).longValue();
                }
            }
        }
        return defaultValue;
    }

    @Override
    public String getValueAsString(String defaultValue) throws IOException, JsonParseException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return defaultValue;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException, JsonParseException {
        int n = 0;
        int n2 = string.length();
        block0: while (n < n2) {
            char c;
            do {
                c = string.charAt(n++);
                if (n >= n2) break block0;
            } while (c <= ' ');
            int n3 = base64Variant.decodeBase64Char(c);
            if (n3 < 0) {
                this._reportInvalidBase64(base64Variant, c, 0, null);
            }
            int n4 = n3;
            if (n >= n2) {
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                this._reportInvalidBase64(base64Variant, c, 1, null);
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.append(n4 >>= 4);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 2, null);
                }
                if (n >= n2) {
                    this._reportBase64EOF();
                }
                if (!base64Variant.usesPaddingChar(c = string.charAt(n++))) {
                    this._reportInvalidBase64(base64Variant, c, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n4 >>= 4);
                continue;
            }
            n4 = n4 << 6 | n3;
            if (n >= n2) {
                if (!base64Variant.usesPadding()) {
                    byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                    break;
                }
                this._reportBase64EOF();
            }
            if ((n3 = base64Variant.decodeBase64Char(c = string.charAt(n++))) < 0) {
                if (n3 != -2) {
                    this._reportInvalidBase64(base64Variant, c, 3, null);
                }
                byteArrayBuilder.appendTwoBytes(n4 >>= 2);
                continue;
            }
            n4 = n4 << 6 | n3;
            byteArrayBuilder.appendThreeBytes(n4);
        }
    }

    protected void _reportInvalidBase64(Base64Variant base64Variant, char c, int n, String string) throws JsonParseException {
        String string2 = c <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c) + ") as character #" + (n + 1) + " of 4-char base64 unit: can only used between units" : (base64Variant.usesPaddingChar(c) ? "Unexpected padding character ('" + base64Variant.getPaddingChar() + "') as character #" + (n + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c) || Character.isISOControl(c) ? "Illegal character (code 0x" + Integer.toHexString(c) + ") in base64 content" : "Illegal character '" + c + "' (code 0x" + Integer.toHexString(c) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructError(string2);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw this._constructError("Unexpected end-of-String in base64 content");
    }

    protected void _reportUnexpectedChar(int n, String string) throws JsonParseException {
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) throws JsonParseException {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _reportInvalidEOFInValue() throws JsonParseException {
        this._reportInvalidEOF(" in a value");
    }

    protected void _throwInvalidSpace(int n) throws JsonParseException {
        char c = (char)n;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n, String string) throws JsonParseException {
        if (!this.isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n >= 32) {
            char c = (char)n;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(c) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c) throws JsonProcessingException {
        if (this.isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c;
        }
        if (c == '\'' && this.isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES)) {
            return c;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c));
        return c;
    }

    protected static final String _getCharDesc(int n) {
        char c = (char)n;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + n + ")";
        }
        if (n > 255) {
            return "'" + c + "' (code " + n + " / 0x" + Integer.toHexString(n) + ")";
        }
        return "'" + c + "' (code " + n + ")";
    }

    protected final void _reportError(String msg) throws JsonParseException {
        throw this._constructError(msg);
    }

    protected final void _wrapError(String msg, Throwable t) throws JsonParseException {
        throw this._constructError(msg, t);
    }

    protected final void _throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }

    protected final JsonParseException _constructError(String msg, Throwable t) {
        return new JsonParseException(msg, this.getCurrentLocation(), t);
    }
}

