/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind;

import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.core.Base64Variant;
import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationConfig;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationFeature;
import com.amazonaws.com.fasterxml.jackson.databind.InjectableValues;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.KeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.MapperFeature;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DeserializerCache;
import com.amazonaws.com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.amazonaws.com.fasterxml.jackson.databind.deser.impl.TypeWrappedDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.amazonaws.com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.type.TypeFactory;
import com.amazonaws.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.amazonaws.com.fasterxml.jackson.databind.util.ClassUtil;
import com.amazonaws.com.fasterxml.jackson.databind.util.LinkedNode;
import com.amazonaws.com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DeserializationContext
implements Serializable {
    protected final DeserializerCache _cache;
    protected final DeserializerFactory _factory;
    protected final DeserializationConfig _config;
    protected final int _featureFlags;
    protected final Class<?> _view;
    protected transient JsonParser _parser;
    protected final InjectableValues _injectableValues;
    protected transient ArrayBuilders _arrayBuilders;
    protected transient ObjectBuffer _objectBuffer;
    protected transient DateFormat _dateFormat;

    protected DeserializationContext(DeserializerFactory df) {
        this(df, null);
    }

    protected DeserializationContext(DeserializerFactory df, DeserializerCache cache) {
        if (df == null) {
            throw new IllegalArgumentException("Can not pass null DeserializerFactory");
        }
        this._factory = df;
        this._cache = cache == null ? new DeserializerCache() : cache;
        this._featureFlags = 0;
        this._config = null;
        this._injectableValues = null;
        this._view = null;
    }

    protected DeserializationContext(DeserializationContext src, DeserializationConfig config, JsonParser jp, InjectableValues injectableValues) {
        this._cache = src._cache;
        this._factory = src._factory;
        this._config = config;
        this._featureFlags = config.getDeserializationFeatures();
        this._view = config.getActiveView();
        this._parser = jp;
        this._injectableValues = injectableValues;
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    public final boolean isEnabled(DeserializationFeature feat) {
        return (this._featureFlags & feat.getMask()) != 0;
    }

    public final boolean isEnabled(MapperFeature feat) {
        return this._config.isEnabled(feat);
    }

    public final AnnotationIntrospector getAnnotationIntrospector() {
        return this._config.getAnnotationIntrospector();
    }

    public final JsonParser getParser() {
        return this._parser;
    }

    public final Object findInjectableValue(Object valueId, BeanProperty forProperty, Object beanInstance) {
        if (this._injectableValues == null) {
            throw new IllegalStateException("No 'injectableValues' configured, can not inject value with id [" + valueId + "]");
        }
        return this._injectableValues.findInjectableValue(valueId, this, forProperty, beanInstance);
    }

    public final Class<?> getActiveView() {
        return this._view;
    }

    public final boolean canOverrideAccessModifiers() {
        return this._config.canOverrideAccessModifiers();
    }

    public final Base64Variant getBase64Variant() {
        return this._config.getBase64Variant();
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._config.getNodeFactory();
    }

    public final TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public Locale getLocale() {
        return this._config.getLocale();
    }

    public TimeZone getTimeZone() {
        return this._config.getTimeZone();
    }

    public final JsonDeserializer<Object> findContextualValueDeserializer(JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser != null && deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, property);
        }
        return deser;
    }

    public final JsonDeserializer<Object> findRootValueDeserializer(JavaType type) throws JsonMappingException {
        TypeDeserializer typeDeser;
        JsonDeserializer<Object> deser = this._cache.findValueDeserializer(this, this._factory, type);
        if (deser == null) {
            return null;
        }
        if (deser instanceof ContextualDeserializer) {
            deser = ((ContextualDeserializer)((Object)deser)).createContextual(this, null);
        }
        if ((typeDeser = this._factory.findTypeDeserializer(this._config, type)) != null) {
            typeDeser = typeDeser.forProperty(null);
            return new TypeWrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    public final KeyDeserializer findKeyDeserializer(JavaType keyType, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._cache.findKeyDeserializer(this, this._factory, keyType);
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(this, property);
        }
        return kd;
    }

    public abstract ReadableObjectId findObjectId(Object var1, ObjectIdGenerator<?> var2);

    public final JavaType constructType(Class<?> cls) {
        return this._config.constructType(cls);
    }

    public Class<?> findClass(String className) throws ClassNotFoundException {
        return ClassUtil.findClass(className);
    }

    public abstract JsonDeserializer<Object> deserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract KeyDeserializer keyDeserializerInstance(Annotated var1, Object var2) throws JsonMappingException;

    public abstract ObjectIdGenerator<?> objectIdGeneratorInstance(Annotated var1, ObjectIdInfo var2) throws JsonMappingException;

    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer buf = this._objectBuffer;
        if (buf == null) {
            buf = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return buf;
    }

    public final void returnObjectBuffer(ObjectBuffer buf) {
        if (this._objectBuffer == null || buf.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = buf;
        }
    }

    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    public Date parseDate(String string) throws IllegalArgumentException {
        try {
            return this.getDateFormat().parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Failed to parse Date value '" + string + "': " + parseException.getMessage());
        }
    }

    public Calendar constructCalendar(Date d) {
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(d);
        return c;
    }

    public boolean handleUnknownProperty(JsonParser jp, JsonDeserializer<?> deser, Object instanceOrClass, String propName) throws IOException, JsonProcessingException {
        LinkedNode<DeserializationProblemHandler> h = this._config.getProblemHandlers();
        if (h != null) {
            while (h != null) {
                if (h.value().handleUnknownProperty(this, jp, deser, instanceOrClass, propName)) {
                    return true;
                }
                h = h.next();
            }
        }
        return false;
    }

    public void reportUnknownProperty(Object instanceOrClass, String fieldName, JsonDeserializer<?> deser) throws JsonMappingException {
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)) {
            return;
        }
        Collection<Object> propIds = deser == null ? null : deser.getKnownPropertyNames();
        throw UnrecognizedPropertyException.from(this._parser, instanceOrClass, fieldName, propIds);
    }

    public JsonMappingException mappingException(Class<?> targetClass) {
        return this.mappingException(targetClass, this._parser.getCurrentToken());
    }

    public JsonMappingException mappingException(Class<?> clazz, JsonToken jsonToken) {
        String string = this._calcName(clazz);
        return JsonMappingException.from(this._parser, "Can not deserialize instance of " + string + " out of " + (Object)((Object)jsonToken) + " token");
    }

    public JsonMappingException mappingException(String message) {
        return JsonMappingException.from(this.getParser(), message);
    }

    public JsonMappingException instantiationException(Class<?> clazz, Throwable throwable) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + clazz.getName() + ", problem: " + throwable.getMessage(), throwable);
    }

    public JsonMappingException instantiationException(Class<?> clazz, String string) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + clazz.getName() + ", problem: " + string);
    }

    public JsonMappingException weirdStringException(String string, Class<?> clazz, String string2) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + clazz.getName() + " from String value '" + this._valueDesc() + "': " + string2, string, clazz);
    }

    public JsonMappingException weirdNumberException(Number number, Class<?> clazz, String string) {
        return InvalidFormatException.from(this._parser, "Can not construct instance of " + clazz.getName() + " from number value (" + this._valueDesc() + "): " + string, null, clazz);
    }

    public JsonMappingException weirdKeyException(Class<?> clazz, String string, String string2) {
        return InvalidFormatException.from(this._parser, "Can not construct Map key of type " + clazz.getName() + " from String \"" + this._desc(string) + "\": " + string2, string, clazz);
    }

    public JsonMappingException wrongTokenException(JsonParser jsonParser, JsonToken jsonToken, String string) {
        return JsonMappingException.from(jsonParser, "Unexpected token (" + (Object)((Object)jsonParser.getCurrentToken()) + "), expected " + (Object)((Object)jsonToken) + ": " + string);
    }

    public JsonMappingException unknownTypeException(JavaType javaType, String string) {
        return JsonMappingException.from(this._parser, "Could not resolve type id '" + string + "' into a subtype of " + javaType);
    }

    public JsonMappingException endOfInputException(Class<?> clazz) {
        return JsonMappingException.from(this._parser, "Unexpected end-of-input when trying to deserialize a " + clazz.getName());
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat != null) {
            return this._dateFormat;
        }
        DateFormat df = this._config.getDateFormat();
        this._dateFormat = df = (DateFormat)df.clone();
        return df;
    }

    protected String _calcName(Class<?> clazz) {
        if (clazz.isArray()) {
            return this._calcName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception exception) {
            return "[N/A]";
        }
    }

    protected String _desc(String string) {
        if (string.length() > 500) {
            string = string.substring(0, 500) + "]...[" + string.substring(string.length() - 500);
        }
        return string;
    }
}

