/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.deser.std;

import com.amazonaws.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.com.fasterxml.jackson.core.JsonProcessingException;
import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.com.fasterxml.jackson.core.io.NumberInput;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.KeyDeserializer;
import com.amazonaws.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    public Class<?> getValueClass() {
        return this._valueClass;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return deserializer != null && deserializer.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return keyDeser != null && keyDeser.getClass().getAnnotation(JacksonStdImpl.class) != null;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromAny(jp, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() != 0;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text)) {
                return true;
            }
            if ("false".equals(text) || text.length() == 0) {
                return Boolean.FALSE;
            }
            throw ctxt.weirdStringException(text, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final Boolean _parseBoolean(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            if (jp.getNumberType() == JsonParser.NumberType.INT) {
                return jp.getIntValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            return this._parseBooleanFromNumber(jp, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            if ("true".equals(text)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text)) {
                return Boolean.FALSE;
            }
            if (text.length() == 0) {
                return (Boolean)this.getEmptyValue();
            }
            throw ctxt.weirdStringException(text, this._valueClass, "only \"true\" or \"false\" recognized");
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final boolean _parseBooleanFromNumber(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getNumberType() == JsonParser.NumberType.LONG) {
            return jp.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
        String str = jp.getText();
        if ("0.0".equals(str) || "0".equals(str)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected Byte _parseByte(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue();
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Byte value");
            }
            if (value < -128 || value > 255) {
                throw ctxt.weirdStringException(text, this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected Short _parseShort(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value;
            String text = jp.getText().trim();
            try {
                int len = text.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue();
                }
                value = NumberInput.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(text, this._valueClass, "not a valid Short value");
            }
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdStringException(text, this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue();
        }
        throw ctxt.mappingException(this._valueClass, t);
    }

    protected final short _parseShortPrimitive(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        int value = this._parseIntPrimitive(jp, ctxt);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw ctxt.weirdStringException(String.valueOf(value), this._valueClass, "overflow, value can not be represented as 16-bit value");
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n = string.length();
                if (n > 9) {
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(string, this._valueClass, "Overflow: numeric value (" + string + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (n == 0) {
                    return 0;
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid int value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Integer _parseInteger(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                int n = string.length();
                if (n > 9) {
                    long l = Long.parseLong(string);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        throw deserializationContext.weirdStringException(string, this._valueClass, "Overflow: numeric value (" + string + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
                    }
                    return (int)l;
                }
                if (n == 0) {
                    return (Integer)this.getEmptyValue();
                }
                return NumberInput.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Integer value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Integer)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Long _parseLong(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Long)this.getEmptyValue();
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Long)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final long _parseLongPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0L;
            }
            try {
                return NumberInput.parseLong(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid long value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0L;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Float _parseFloat(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(jsonParser.getFloatValue());
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Float)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final float _parseFloatPrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getFloatValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0f;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid float value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final Double _parseDouble(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return (Double)this.getEmptyValue();
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid Double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue();
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected final double _parseDoublePrimitive(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return jsonParser.getDoubleValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return 0.0;
            }
            switch (string.charAt(0)) {
                case 'I': {
                    if (!"Infinity".equals(string) && !"INF".equals(string)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!"NaN".equals(string)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!"-Infinity".equals(string) && !"-INF".equals(string)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid double value");
            }
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected Date _parseDate(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return new Date(jsonParser.getLongValue());
        }
        if (jsonToken == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue();
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = null;
            try {
                string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return (Date)this.getEmptyValue();
                }
                return deserializationContext.parseDate(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid representation (error: " + illegalArgumentException.getMessage() + ")");
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }

    protected static final double parseDouble(String string) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(string)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(string);
    }

    protected final String _parseString(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String value = jp.getValueAsString();
        if (value != null) {
            return value;
        }
        throw ctxt.mappingException(String.class, jp.getCurrentToken());
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property);
    }

    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException, JsonProcessingException {
        if (instanceOrClass == null) {
            instanceOrClass = this.getValueClass();
        }
        if (ctxt.handleUnknownProperty(jp, this, instanceOrClass, propName)) {
            return;
        }
        ctxt.reportUnknownProperty(instanceOrClass, propName, this);
        jp.skipChildren();
    }
}

