/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.introspect;

import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;

public class POJOPropertyBuilder
extends BeanPropertyDefinition
implements Comparable<POJOPropertyBuilder> {
    protected final boolean _forSerialization;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final String _name;
    protected final String _internalName;
    protected Linked<AnnotatedField> _fields;
    protected Linked<AnnotatedParameter> _ctorParameters;
    protected Linked<AnnotatedMethod> _getters;
    protected Linked<AnnotatedMethod> _setters;

    public POJOPropertyBuilder(String internalName, AnnotationIntrospector annotationIntrospector, boolean forSerialization) {
        this._internalName = internalName;
        this._name = internalName;
        this._annotationIntrospector = annotationIntrospector;
        this._forSerialization = forSerialization;
    }

    public POJOPropertyBuilder(POJOPropertyBuilder src, String newName) {
        this._internalName = src._internalName;
        this._name = newName;
        this._annotationIntrospector = src._annotationIntrospector;
        this._fields = src._fields;
        this._ctorParameters = src._ctorParameters;
        this._getters = src._getters;
        this._setters = src._setters;
        this._forSerialization = src._forSerialization;
    }

    public POJOPropertyBuilder withName(String newName) {
        return new POJOPropertyBuilder(this, newName);
    }

    @Override
    public int compareTo(POJOPropertyBuilder other) {
        if (this._ctorParameters != null) {
            if (other._ctorParameters == null) {
                return -1;
            }
        } else if (other._ctorParameters != null) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String getInternalName() {
        return this._internalName;
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return this._anyExplicitNames(this._fields) || this._anyExplicitNames(this._getters) || this._anyExplicitNames(this._setters) || this._anyExplicitNames(this._ctorParameters);
    }

    @Override
    public boolean hasGetter() {
        return this._getters != null;
    }

    @Override
    public boolean hasSetter() {
        return this._setters != null;
    }

    @Override
    public boolean hasField() {
        return this._fields != null;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._ctorParameters != null;
    }

    @Override
    public AnnotatedMethod getGetter() {
        if (this._getters == null) {
            return null;
        }
        AnnotatedMethod getter = (AnnotatedMethod)this._getters.value;
        Linked next = this._getters.next;
        while (next != null) {
            block7: {
                AnnotatedMethod nextGetter;
                block5: {
                    Class<?> nextClass;
                    Class<?> getterClass;
                    block6: {
                        nextGetter = (AnnotatedMethod)next.value;
                        getterClass = getter.getDeclaringClass();
                        if (getterClass == (nextClass = nextGetter.getDeclaringClass())) break block5;
                        if (!getterClass.isAssignableFrom(nextClass)) break block6;
                        getter = nextGetter;
                        break block7;
                    }
                    if (nextClass.isAssignableFrom(getterClass)) break block7;
                }
                throw new IllegalArgumentException("Conflicting getter definitions for property \"" + this.getName() + "\": " + getter.getFullName() + " vs " + nextGetter.getFullName());
            }
            next = next.next;
        }
        return getter;
    }

    @Override
    public AnnotatedMethod getSetter() {
        if (this._setters == null) {
            return null;
        }
        AnnotatedMethod setter = (AnnotatedMethod)this._setters.value;
        Linked next = this._setters.next;
        while (next != null) {
            block7: {
                AnnotatedMethod nextSetter;
                block5: {
                    Class<?> nextClass;
                    Class<?> setterClass;
                    block6: {
                        nextSetter = (AnnotatedMethod)next.value;
                        setterClass = setter.getDeclaringClass();
                        if (setterClass == (nextClass = nextSetter.getDeclaringClass())) break block5;
                        if (!setterClass.isAssignableFrom(nextClass)) break block6;
                        setter = nextSetter;
                        break block7;
                    }
                    if (nextClass.isAssignableFrom(setterClass)) break block7;
                }
                throw new IllegalArgumentException("Conflicting setter definitions for property \"" + this.getName() + "\": " + setter.getFullName() + " vs " + nextSetter.getFullName());
            }
            next = next.next;
        }
        return setter;
    }

    @Override
    public AnnotatedField getField() {
        if (this._fields == null) {
            return null;
        }
        AnnotatedField field = (AnnotatedField)this._fields.value;
        Linked next = this._fields.next;
        while (next != null) {
            block7: {
                AnnotatedField nextField;
                block5: {
                    Class<?> nextClass;
                    Class<?> fieldClass;
                    block6: {
                        nextField = (AnnotatedField)next.value;
                        fieldClass = field.getDeclaringClass();
                        if (fieldClass == (nextClass = nextField.getDeclaringClass())) break block5;
                        if (!fieldClass.isAssignableFrom(nextClass)) break block6;
                        field = nextField;
                        break block7;
                    }
                    if (nextClass.isAssignableFrom(fieldClass)) break block7;
                }
                throw new IllegalArgumentException("Multiple fields representing property \"" + this.getName() + "\": " + field.getFullName() + " vs " + nextField.getFullName());
            }
            next = next.next;
        }
        return field;
    }

    public AnnotatedParameter getConstructorParameter() {
        if (this._ctorParameters == null) {
            return null;
        }
        Linked<AnnotatedParameter> curr = this._ctorParameters;
        do {
            if (!(((AnnotatedParameter)curr.value).getOwner() instanceof AnnotatedConstructor)) continue;
            return (AnnotatedParameter)curr.value;
        } while ((curr = curr.next) != null);
        return (AnnotatedParameter)this._ctorParameters.value;
    }

    @Override
    public AnnotatedMember getAccessor() {
        AnnotatedMember m = this.getGetter();
        if (m == null) {
            m = this.getField();
        }
        return m;
    }

    @Override
    public AnnotatedMember getMutator() {
        AnnotatedMember m = this.getConstructorParameter();
        if (m == null && (m = this.getSetter()) == null) {
            m = this.getField();
        }
        return m;
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        if (this._forSerialization) {
            return this.getAccessor();
        }
        return this.getMutator();
    }

    @Override
    public Class<?>[] findViews() {
        return this.fromMemberAnnotations(new WithMember<Class<?>[]>(){

            @Override
            public Class<?>[] withMember(AnnotatedMember member) {
                return POJOPropertyBuilder.this._annotationIntrospector.findViews(member);
            }
        });
    }

    @Override
    public AnnotationIntrospector.ReferenceProperty findReferenceType() {
        return this.fromMemberAnnotations(new WithMember<AnnotationIntrospector.ReferenceProperty>(){

            @Override
            public AnnotationIntrospector.ReferenceProperty withMember(AnnotatedMember member) {
                return POJOPropertyBuilder.this._annotationIntrospector.findReferenceType(member);
            }
        });
    }

    @Override
    public boolean isTypeId() {
        Boolean b = this.fromMemberAnnotations(new WithMember<Boolean>(){

            @Override
            public Boolean withMember(AnnotatedMember member) {
                return POJOPropertyBuilder.this._annotationIntrospector.isTypeId(member);
            }
        });
        return b != null && b != false;
    }

    public void addField(AnnotatedField a, String ename, boolean visible, boolean ignored) {
        this._fields = new Linked<AnnotatedField>(a, this._fields, ename, visible, ignored);
    }

    public void addCtor(AnnotatedParameter a, String ename, boolean visible, boolean ignored) {
        this._ctorParameters = new Linked<AnnotatedParameter>(a, this._ctorParameters, ename, visible, ignored);
    }

    public void addGetter(AnnotatedMethod a, String ename, boolean visible, boolean ignored) {
        this._getters = new Linked<AnnotatedMethod>(a, this._getters, ename, visible, ignored);
    }

    public void addSetter(AnnotatedMethod a, String ename, boolean visible, boolean ignored) {
        this._setters = new Linked<AnnotatedMethod>(a, this._setters, ename, visible, ignored);
    }

    public void addAll(POJOPropertyBuilder src) {
        this._fields = POJOPropertyBuilder.merge(this._fields, src._fields);
        this._ctorParameters = POJOPropertyBuilder.merge(this._ctorParameters, src._ctorParameters);
        this._getters = POJOPropertyBuilder.merge(this._getters, src._getters);
        this._setters = POJOPropertyBuilder.merge(this._setters, src._setters);
    }

    private static <T> Linked<T> merge(Linked<T> chain1, Linked<T> chain2) {
        if (chain1 == null) {
            return chain2;
        }
        if (chain2 == null) {
            return chain1;
        }
        return ((Linked)chain1).append((Linked)chain2);
    }

    public void removeIgnored() {
        this._fields = this._removeIgnored(this._fields);
        this._getters = this._removeIgnored(this._getters);
        this._setters = this._removeIgnored(this._setters);
        this._ctorParameters = this._removeIgnored(this._ctorParameters);
    }

    public void removeNonVisible() {
        this._getters = this._removeNonVisible(this._getters);
        this._ctorParameters = this._removeNonVisible(this._ctorParameters);
        if (this._getters == null) {
            this._fields = this._removeNonVisible(this._fields);
            this._setters = this._removeNonVisible(this._setters);
        }
    }

    public void trimByVisibility() {
        this._fields = this._trimByVisibility(this._fields);
        this._getters = this._trimByVisibility(this._getters);
        this._setters = this._trimByVisibility(this._setters);
        this._ctorParameters = this._trimByVisibility(this._ctorParameters);
    }

    public void mergeAnnotations(boolean forSerialization) {
        if (forSerialization) {
            if (this._getters != null) {
                AnnotationMap ann = this._mergeAnnotations(0, this._getters, this._fields, this._ctorParameters, this._setters);
                this._getters = this._getters.withValue(((AnnotatedMethod)this._getters.value).withAnnotations(ann));
            } else if (this._fields != null) {
                AnnotationMap ann = this._mergeAnnotations(0, this._fields, this._ctorParameters, this._setters);
                this._fields = this._fields.withValue(((AnnotatedField)this._fields.value).withAnnotations(ann));
            }
        } else if (this._ctorParameters != null) {
            AnnotationMap ann = this._mergeAnnotations(0, this._ctorParameters, this._setters, this._fields, this._getters);
            this._ctorParameters = this._ctorParameters.withValue(((AnnotatedParameter)this._ctorParameters.value).withAnnotations(ann));
        } else if (this._setters != null) {
            AnnotationMap ann = this._mergeAnnotations(0, this._setters, this._fields, this._getters);
            this._setters = this._setters.withValue(((AnnotatedMethod)this._setters.value).withAnnotations(ann));
        } else if (this._fields != null) {
            AnnotationMap ann = this._mergeAnnotations(0, this._fields, this._getters);
            this._fields = this._fields.withValue(((AnnotatedField)this._fields.value).withAnnotations(ann));
        }
    }

    private AnnotationMap _mergeAnnotations(int index, Linked<? extends AnnotatedMember> ... nodes) {
        AnnotationMap ann = ((AnnotatedMember)nodes[index].value).getAllAnnotations();
        ++index;
        while (index < nodes.length) {
            if (nodes[index] != null) {
                return AnnotationMap.merge(ann, this._mergeAnnotations(index, nodes));
            }
            ++index;
        }
        return ann;
    }

    private <T> Linked<T> _removeIgnored(Linked<T> node) {
        if (node == null) {
            return node;
        }
        return node.withoutIgnored();
    }

    private <T> Linked<T> _removeNonVisible(Linked<T> node) {
        if (node == null) {
            return node;
        }
        return node.withoutNonVisible();
    }

    private <T> Linked<T> _trimByVisibility(Linked<T> node) {
        if (node == null) {
            return node;
        }
        return node.trimByVisibility();
    }

    private <T> boolean _anyExplicitNames(Linked<T> n) {
        while (n != null) {
            if (n.explicitName != null && n.explicitName.length() > 0) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public boolean anyVisible() {
        return this._anyVisible(this._fields) || this._anyVisible(this._getters) || this._anyVisible(this._setters) || this._anyVisible(this._ctorParameters);
    }

    private <T> boolean _anyVisible(Linked<T> n) {
        while (n != null) {
            if (n.isVisible) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public boolean anyIgnorals() {
        return this._anyIgnorals(this._fields) || this._anyIgnorals(this._getters) || this._anyIgnorals(this._setters) || this._anyIgnorals(this._ctorParameters);
    }

    private <T> boolean _anyIgnorals(Linked<T> n) {
        while (n != null) {
            if (n.isMarkedIgnored) {
                return true;
            }
            n = n.next;
        }
        return false;
    }

    public String findNewName() {
        Linked<? extends AnnotatedMember> renamed = null;
        renamed = this.findRenamed(this._fields, renamed);
        renamed = this.findRenamed(this._getters, renamed);
        renamed = this.findRenamed(this._setters, renamed);
        return (renamed = this.findRenamed(this._ctorParameters, renamed)) == null ? null : renamed.explicitName;
    }

    private Linked<? extends AnnotatedMember> findRenamed(Linked<? extends AnnotatedMember> linked, Linked<? extends AnnotatedMember> linked2) {
        while (linked != null) {
            String string = linked.explicitName;
            if (string != null && !string.equals(this._name)) {
                if (linked2 == null) {
                    linked2 = linked;
                } else if (!string.equals(linked2.explicitName)) {
                    throw new IllegalStateException("Conflicting property name definitions: '" + linked2.explicitName + "' (for " + linked2.value + ") vs '" + linked.explicitName + "' (for " + linked.value + ")");
                }
            }
            linked = linked.next;
        }
        return linked2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Property '").append(this._name).append("'; ctors: ").append(this._ctorParameters).append(", field(s): ").append(this._fields).append(", getter(s): ").append(this._getters).append(", setter(s): ").append(this._setters);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected <T> T fromMemberAnnotations(WithMember<T> func) {
        T result = null;
        if (this._annotationIntrospector != null) {
            if (this._forSerialization) {
                if (this._getters != null) {
                    result = func.withMember((AnnotatedMember)this._getters.value);
                }
            } else {
                if (this._ctorParameters != null) {
                    result = func.withMember((AnnotatedMember)this._ctorParameters.value);
                }
                if (result == null && this._setters != null) {
                    result = func.withMember((AnnotatedMember)this._setters.value);
                }
            }
            if (result == null && this._fields != null) {
                result = func.withMember((AnnotatedMember)this._fields.value);
            }
        }
        return result;
    }

    private static final class Linked<T> {
        public final T value;
        public final Linked<T> next;
        public final String explicitName;
        public final boolean isVisible;
        public final boolean isMarkedIgnored;

        public Linked(T v, Linked<T> n, String explName, boolean visible, boolean ignored) {
            this.value = v;
            this.next = n;
            this.explicitName = explName == null ? null : (explName.length() == 0 ? null : explName);
            this.isVisible = visible;
            this.isMarkedIgnored = ignored;
        }

        public Linked<T> withValue(T newValue) {
            if (newValue == this.value) {
                return this;
            }
            return new Linked<T>(newValue, this.next, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withNext(Linked<T> newNext) {
            if (newNext == this.next) {
                return this;
            }
            return new Linked<T>(this.value, newNext, this.explicitName, this.isVisible, this.isMarkedIgnored);
        }

        public Linked<T> withoutIgnored() {
            Linked<T> newNext;
            if (this.isMarkedIgnored) {
                return this.next == null ? null : this.next.withoutIgnored();
            }
            if (this.next != null && (newNext = this.next.withoutIgnored()) != this.next) {
                return this.withNext(newNext);
            }
            return this;
        }

        public Linked<T> withoutNonVisible() {
            Linked<T> newNext = this.next == null ? null : this.next.withoutNonVisible();
            return this.isVisible ? this.withNext(newNext) : newNext;
        }

        private Linked<T> append(Linked<T> appendable) {
            if (this.next == null) {
                return this.withNext(appendable);
            }
            return this.withNext(super.append(appendable));
        }

        public Linked<T> trimByVisibility() {
            if (this.next == null) {
                return this;
            }
            Linked<T> newNext = this.next.trimByVisibility();
            if (this.explicitName != null) {
                if (newNext.explicitName == null) {
                    return this.withNext(null);
                }
                return this.withNext(newNext);
            }
            if (newNext.explicitName != null) {
                return newNext;
            }
            if (this.isVisible == newNext.isVisible) {
                return this.withNext(newNext);
            }
            return this.isVisible ? this.withNext(null) : newNext;
        }

        public String toString() {
            String msg = this.value.toString() + "[visible=" + this.isVisible + "]";
            if (this.next != null) {
                msg = msg + ", " + this.next.toString();
            }
            return msg;
        }
    }

    private static interface WithMember<T> {
        public T withMember(AnnotatedMember var1);
    }
}

