/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.com.fasterxml.jackson.databind.ser.std;

import com.amazonaws.com.fasterxml.jackson.annotation.JsonFormat;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerationException;
import com.amazonaws.com.fasterxml.jackson.core.JsonGenerator;
import com.amazonaws.com.fasterxml.jackson.core.io.SerializedString;
import com.amazonaws.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.amazonaws.com.fasterxml.jackson.databind.BeanProperty;
import com.amazonaws.com.fasterxml.jackson.databind.JavaType;
import com.amazonaws.com.fasterxml.jackson.databind.JsonMappingException;
import com.amazonaws.com.fasterxml.jackson.databind.JsonSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.SerializerProvider;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.Annotated;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.amazonaws.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.amazonaws.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.amazonaws.com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.amazonaws.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.amazonaws.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.FilterProvider;
import com.amazonaws.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.amazonaws.com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.amazonaws.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.amazonaws.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.amazonaws.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class BeanSerializerBase
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer {
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final AnyGetterWriter _anyGetterWriter;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat.Shape _serializationShape;

    protected BeanSerializerBase(JavaType type, BeanSerializerBuilder builder, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(type);
        this._props = properties;
        this._filteredProps = filteredProperties;
        if (builder == null) {
            this._typeId = null;
            this._anyGetterWriter = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
        } else {
            this._typeId = builder.getTypeId();
            this._anyGetterWriter = builder.getAnyGetter();
            this._propertyFilterId = builder.getFilterId();
            this._objectIdWriter = builder.getObjectIdWriter();
            JsonFormat.Value format = builder.getBeanDescription().findExpectedFormat(null);
            this._serializationShape = format == null ? null : format.getShape();
        }
    }

    public BeanSerializerBase(BeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(src._handledType);
        this._props = properties;
        this._filteredProps = filteredProperties;
        this._typeId = src._typeId;
        this._anyGetterWriter = src._anyGetterWriter;
        this._objectIdWriter = src._objectIdWriter;
        this._propertyFilterId = src._propertyFilterId;
        this._serializationShape = src._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        super(src._handledType);
        this._props = src._props;
        this._filteredProps = src._filteredProps;
        this._typeId = src._typeId;
        this._anyGetterWriter = src._anyGetterWriter;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = src._propertyFilterId;
        this._serializationShape = src._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase src, String[] toIgnore) {
        super(src._handledType);
        HashSet<String> ignoredSet = ArrayBuilders.arrayToSet(toIgnore);
        BeanPropertyWriter[] propsIn = src._props;
        BeanPropertyWriter[] fpropsIn = src._filteredProps;
        int len = propsIn.length;
        ArrayList<BeanPropertyWriter> propsOut = new ArrayList<BeanPropertyWriter>(len);
        ArrayList<BeanPropertyWriter> fpropsOut = fpropsIn == null ? null : new ArrayList<BeanPropertyWriter>(len);
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = propsIn[i];
            if (ignoredSet.contains(bpw.getName())) continue;
            propsOut.add(bpw);
            if (fpropsIn == null) continue;
            fpropsOut.add(fpropsIn[i]);
        }
        this._props = propsOut.toArray(new BeanPropertyWriter[propsOut.size()]);
        this._filteredProps = fpropsOut == null ? null : fpropsOut.toArray(new BeanPropertyWriter[fpropsOut.size()]);
        this._typeId = src._typeId;
        this._anyGetterWriter = src._anyGetterWriter;
        this._objectIdWriter = src._objectIdWriter;
        this._propertyFilterId = src._propertyFilterId;
        this._serializationShape = src._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withIgnorals(String[] var1);

    protected abstract BeanSerializerBase asArraySerializer();

    protected BeanSerializerBase(BeanSerializerBase src) {
        this(src, src._props, src._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase src, NameTransformer unwrapper) {
        this(src, BeanSerializerBase.rename(src._props, unwrapper), BeanSerializerBase.rename(src._filteredProps, unwrapper));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] props, NameTransformer transformer) {
        if (props == null || props.length == 0 || transformer == null || transformer == NameTransformer.NOP) {
            return props;
        }
        int len = props.length;
        BeanPropertyWriter[] result = new BeanPropertyWriter[len];
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = props[i];
            if (bpw == null) continue;
            result[i] = bpw.rename(transformer);
        }
        return result;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        int filteredCount = this._filteredProps == null ? 0 : this._filteredProps.length;
        int len = this._props.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter w2;
            TypeSerializer typeSer;
            JsonSerializer<Object> nullSer;
            BeanPropertyWriter prop = this._props[i];
            if (!prop.willSuppressNulls() && !prop.hasNullSerializer() && (nullSer = provider.findNullValueSerializer(prop)) != null) {
                BeanPropertyWriter w22;
                prop.assignNullSerializer(nullSer);
                if (i < filteredCount && (w22 = this._filteredProps[i]) != null) {
                    w22.assignNullSerializer(nullSer);
                }
            }
            if (prop.hasSerializer()) continue;
            JavaType type = prop.getSerializationType();
            if (type == null && !(type = provider.constructType(prop.getGenericPropertyType())).isFinal()) {
                if (!type.isContainerType() && type.containedTypeCount() <= 0) continue;
                prop.setNonTrivialBaseType(type);
                continue;
            }
            JsonSerializer<Object> ser = provider.findValueSerializer(type, (BeanProperty)prop);
            if (type.isContainerType() && (typeSer = (TypeSerializer)type.getContentType().getTypeHandler()) != null && ser instanceof ContainerSerializer) {
                ContainerSerializer<?> ser2 = ((ContainerSerializer)ser).withValueTypeSerializer(typeSer);
                ser = ser2;
            }
            prop.assignSerializer(ser);
            if (i >= filteredCount || (w2 = this._filteredProps[i]) == null) continue;
            w2.assignSerializer(ser);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(provider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        Object object2;
        Object object3;
        AnnotatedMember annotatedMember;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        String[] stringArray = null;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember2 = annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        if (annotatedMember != null) {
            stringArray = annotationIntrospector.findPropertiesToIgnore(annotatedMember);
            object3 = annotationIntrospector.findObjectIdInfo(annotatedMember);
            if (object3 == null) {
                if (objectIdWriter != null) {
                    object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, new ObjectIdInfo("", null, null));
                    objectIdWriter = this._objectIdWriter.withAlwaysAsId(((ObjectIdInfo)object3).getAlwaysAsId());
                }
            } else {
                object3 = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object3);
                object2 = ((ObjectIdInfo)object3).getGeneratorType();
                JavaType javaType = serializerProvider.constructType((Type)object2);
                JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
                if (object2 == ObjectIdGenerators.PropertyGenerator.class) {
                    String string = ((ObjectIdInfo)object3).getPropertyName();
                    BeanPropertyWriter beanPropertyWriter = null;
                    int n = 0;
                    int n2 = this._props.length;
                    while (true) {
                        if (n == n2) {
                            throw new IllegalArgumentException("Invalid Object Id definition for " + this._handledType.getName() + ": can not find property with name '" + string + "'");
                        }
                        BeanPropertyWriter beanPropertyWriter2 = this._props[n];
                        if (string.equals(beanPropertyWriter2.getName())) {
                            beanPropertyWriter = beanPropertyWriter2;
                            if (n <= 0) break;
                            System.arraycopy(this._props, 0, this._props, 1, n);
                            this._props[0] = beanPropertyWriter;
                            if (this._filteredProps == null) break;
                            BeanPropertyWriter beanPropertyWriter3 = this._filteredProps[n];
                            System.arraycopy(this._filteredProps, 0, this._filteredProps, 1, n);
                            this._filteredProps[0] = beanPropertyWriter3;
                            break;
                        }
                        ++n;
                    }
                    javaType2 = beanPropertyWriter.getType();
                    object = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object3, beanPropertyWriter);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, null, object, ((ObjectIdInfo)object3).getAlwaysAsId());
                } else {
                    object = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object3);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, ((ObjectIdInfo)object3).getPropertyName(), object, ((ObjectIdInfo)object3).getAlwaysAsId());
                }
            }
        }
        object3 = this;
        if (objectIdWriter != null && (objectIdWriter = objectIdWriter.withSerializer((JsonSerializer<?>)(object = serializerProvider.findValueSerializer(objectIdWriter.idType, beanProperty)))) != this._objectIdWriter) {
            object3 = ((BeanSerializerBase)object3).withObjectIdWriter(objectIdWriter);
        }
        if (stringArray != null && stringArray.length != 0) {
            object3 = ((BeanSerializerBase)object3).withIgnorals(stringArray);
        }
        object = null;
        if (annotatedMember != null && (object2 = annotationIntrospector.findFormat((Annotated)annotatedMember)) != null) {
            object = ((JsonFormat.Value)object2).getShape();
        }
        if (object == null) {
            object = this._serializationShape;
        }
        if (object == JsonFormat.Shape.ARRAY) {
            object3 = ((BeanSerializerBase)object3).asArraySerializer();
        }
        return object3;
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public void serializeWithType(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        String typeStr;
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, jgen, provider, typeSer);
            return;
        }
        String string = typeStr = this._typeId == null ? null : this._customTypeId(bean);
        if (typeStr == null) {
            typeSer.writeTypePrefixForObject(bean, jgen);
        } else {
            typeSer.writeCustomTypePrefixForObject(bean, jgen, typeStr);
        }
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(bean, jgen, provider);
        } else {
            this.serializeFields(bean, jgen, provider);
        }
        if (typeStr == null) {
            typeSer.writeTypeSuffixForObject(bean, jgen);
        } else {
            typeSer.writeCustomTypeSuffixForObject(bean, jgen, typeStr);
        }
    }

    private final void _serializeWithObjectId(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        String typeStr;
        ObjectIdWriter w = this._objectIdWriter;
        WritableObjectId oid = provider.findObjectId(bean, w.generator);
        Object id = oid.id;
        if (id != null) {
            oid.serializer.serialize(id, jgen, provider);
            return;
        }
        oid.serializer = w.serializer;
        oid.id = id = oid.generator.generateId(bean);
        String string = typeStr = this._typeId == null ? null : this._customTypeId(bean);
        if (typeStr == null) {
            typeSer.writeTypePrefixForObject(bean, jgen);
        } else {
            typeSer.writeCustomTypePrefixForObject(bean, jgen, typeStr);
        }
        SerializedString name = w.propertyName;
        if (name != null) {
            jgen.writeFieldName(name);
            w.serializer.serialize(id, jgen, provider);
        }
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(bean, jgen, provider);
        } else {
            this.serializeFields(bean, jgen, provider);
        }
        if (typeStr == null) {
            typeSer.writeTypeSuffixForObject(bean, jgen);
        } else {
            typeSer.writeCustomTypeSuffixForObject(bean, jgen, typeStr);
        }
    }

    private final String _customTypeId(Object object) {
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            return "";
        }
        return object2 instanceof String ? (String)object2 : object2.toString();
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        BeanPropertyFilter beanPropertyFilter = this.findFilter(serializerProvider);
        if (beanPropertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected BeanPropertyFilter findFilter(SerializerProvider serializerProvider) throws JsonMappingException {
        Object object = this._propertyFilterId;
        FilterProvider filterProvider = serializerProvider.getFilterProvider();
        if (filterProvider == null) {
            throw new JsonMappingException("Can not resolve BeanPropertyFilter with id '" + object + "'; no FilterProvider configured");
        }
        BeanPropertyFilter beanPropertyFilter = filterProvider.findFilter(object);
        return beanPropertyFilter;
    }
}

