/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.javax.xml.stream;

import com.amazonaws.javax.xml.stream.XMLEventReader;
import com.amazonaws.javax.xml.stream.XMLStreamException;
import com.amazonaws.javax.xml.stream.XMLStreamReader;
import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.javax.xml.stream.events.XMLEventAllocatorImpl;
import com.amazonaws.javax.xml.stream.util.XMLEventAllocator;
import java.util.NoSuchElementException;

public class XMLEventReaderImpl
implements XMLEventReader {
    protected XMLStreamReader fXMLReader;
    protected XMLEventAllocator fXMLEventAllocator;
    private XMLEvent fPeekedEvent;
    private XMLEvent fLastEvent;

    public XMLEventReaderImpl(XMLStreamReader reader) throws XMLStreamException {
        this.fXMLReader = reader;
        this.fXMLEventAllocator = (XMLEventAllocator)reader.getProperty("com.amazonaws.javax.xml.stream.allocator");
        if (this.fXMLEventAllocator == null) {
            this.fXMLEventAllocator = new XMLEventAllocatorImpl();
        }
        this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
    }

    public boolean hasNext() {
        if (this.fPeekedEvent != null) {
            return true;
        }
        boolean next = false;
        try {
            next = this.fXMLReader.hasNext();
        }
        catch (XMLStreamException ex) {
            return false;
        }
        return next;
    }

    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            this.fLastEvent = this.fPeekedEvent;
            this.fPeekedEvent = null;
            return this.fLastEvent;
        }
        if (this.fXMLReader.hasNext()) {
            this.fXMLReader.next();
            this.fLastEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fLastEvent;
        }
        this.fLastEvent = null;
        throw new NoSuchElementException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() throws XMLStreamException {
        this.fXMLReader.close();
    }

    public Object next() {
        XMLEvent object = null;
        try {
            object = this.nextEvent();
        }
        catch (XMLStreamException streamException) {
            this.fLastEvent = null;
            throw new NoSuchElementException();
        }
        return object;
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.fPeekedEvent != null) {
            return this.fPeekedEvent;
        }
        if (this.hasNext()) {
            this.fXMLReader.next();
            this.fPeekedEvent = this.fXMLEventAllocator.allocate(this.fXMLReader);
            return this.fPeekedEvent;
        }
        return null;
    }
}

