/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.client.protocol;

import com.amazonaws.org.apache.commons.logging.Log;
import com.amazonaws.org.apache.commons.logging.LogFactory;
import com.amazonaws.org.apache.http.Header;
import com.amazonaws.org.apache.http.HttpException;
import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.HttpRequest;
import com.amazonaws.org.apache.http.HttpRequestInterceptor;
import com.amazonaws.org.apache.http.ProtocolException;
import com.amazonaws.org.apache.http.client.CookieStore;
import com.amazonaws.org.apache.http.client.methods.HttpUriRequest;
import com.amazonaws.org.apache.http.client.params.HttpClientParams;
import com.amazonaws.org.apache.http.conn.HttpRoutedConnection;
import com.amazonaws.org.apache.http.conn.routing.HttpRoute;
import com.amazonaws.org.apache.http.cookie.Cookie;
import com.amazonaws.org.apache.http.cookie.CookieOrigin;
import com.amazonaws.org.apache.http.cookie.CookieSpecRegistry;
import com.amazonaws.org.apache.http.cookie.SetCookie2;
import com.amazonaws.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        URI uRI;
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        CookieStore cookieStore = (CookieStore)httpContext.getAttribute("http.cookie-store");
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        CookieSpecRegistry cookieSpecRegistry = (CookieSpecRegistry)httpContext.getAttribute("http.cookiespec-registry");
        if (cookieSpecRegistry == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost httpHost = (HttpHost)httpContext.getAttribute("http.target_host");
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        HttpRoutedConnection httpRoutedConnection = (HttpRoutedConnection)httpContext.getAttribute("http.connection");
        if (httpRoutedConnection == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        String string2 = HttpClientParams.getCookiePolicy(httpRequest.getParams());
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + string2);
        }
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException("Invalid request URI: " + httpRequest.getRequestLine().getUri(), uRISyntaxException);
            }
        }
        String string3 = httpHost.getHostName();
        int n2 = httpHost.getPort();
        if (n2 < 0) {
            object3 = httpRoutedConnection.getRoute();
            n2 = ((HttpRoute)object3).getHopCount() == 1 ? httpRoutedConnection.getRemotePort() : (((String)(object2 = httpHost.getSchemeName())).equalsIgnoreCase("http") ? 80 : (((String)object2).equalsIgnoreCase("https") ? 443 : 0));
        }
        object3 = new CookieOrigin(string3, n2, uRI.getPath(), httpRoutedConnection.isSecure());
        object2 = cookieSpecRegistry.getCookieSpec(string2, httpRequest.getParams());
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> arrayList2 = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie object4 : arrayList) {
            if (!object4.isExpired(date)) {
                if (!object2.match(object4, (CookieOrigin)object3)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + object4 + " match " + object3);
                }
                arrayList2.add(object4);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + object4 + " expired");
        }
        if (!arrayList2.isEmpty()) {
            List<Header> list = object2.formatCookies(arrayList2);
            Iterator bl = list.iterator();
            while (bl.hasNext()) {
                object = (Header)bl.next();
                httpRequest.addHeader((Header)object);
            }
        }
        if ((n = object2.getVersion()) > 0) {
            boolean bl;
            boolean bl2 = false;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                Cookie cookie = (Cookie)object.next();
                if (n == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                bl = true;
            }
            if (bl && (object = object2.getVersionHeader()) != null) {
                httpRequest.addHeader((Header)object);
            }
        }
        httpContext.setAttribute("http.cookie-spec", object2);
        httpContext.setAttribute("http.cookie-origin", object3);
    }
}

