/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.apache.http.conn.ssl;

import com.amazonaws.org.apache.http.conn.ConnectTimeoutException;
import com.amazonaws.org.apache.http.conn.HttpInetSocketAddress;
import com.amazonaws.org.apache.http.conn.scheme.HostNameResolver;
import com.amazonaws.org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import com.amazonaws.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import com.amazonaws.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import com.amazonaws.org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import com.amazonaws.org.apache.http.conn.ssl.SSLInitializationException;
import com.amazonaws.org.apache.http.conn.ssl.StrictHostnameVerifier;
import com.amazonaws.org.apache.http.conn.ssl.TrustManagerDecorator;
import com.amazonaws.org.apache.http.conn.ssl.TrustStrategy;
import com.amazonaws.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.amazonaws.org.apache.http.params.HttpConnectionParams;
import com.amazonaws.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLSocketFactory
implements LayeredSchemeSocketFactory,
SchemeLayeredSocketFactory {
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier;

    public static SSLSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLSocketFactory(SSLSocketFactory.createDefaultSSLContext());
    }

    private static SSLContext createSSLContext(String algorithm, KeyStore keystore, String keystorePassword, KeyStore truststore, SecureRandom random, TrustStrategy trustStrategy) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, KeyManagementException {
        if (algorithm == null) {
            algorithm = "TLS";
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, keystorePassword != null ? keystorePassword.toCharArray() : null);
        KeyManager[] keymanagers = kmfactory.getKeyManagers();
        TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmfactory.init(truststore);
        TrustManager[] trustmanagers = tmfactory.getTrustManagers();
        if (trustmanagers != null && trustStrategy != null) {
            for (int i = 0; i < trustmanagers.length; ++i) {
                TrustManager tm = trustmanagers[i];
                if (!(tm instanceof X509TrustManager)) continue;
                trustmanagers[i] = new TrustManagerDecorator((X509TrustManager)tm, trustStrategy);
            }
        }
        SSLContext sslcontext = SSLContext.getInstance(algorithm);
        sslcontext.init(keymanagers, trustmanagers, random);
        return sslcontext;
    }

    private static SSLContext createDefaultSSLContext() throws SSLInitializationException {
        try {
            return SSLSocketFactory.createSSLContext("TLS", null, null, null, null, null);
        }
        catch (Exception ex) {
            throw new SSLInitializationException("Failure initializing default SSL context", ex);
        }
    }

    public SSLSocketFactory(SSLContext sslContext) {
        this(sslContext, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
    }

    public SSLSocketFactory(SSLContext sSLContext, X509HostnameVerifier x509HostnameVerifier) {
        if (sSLContext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        this.socketfactory = sSLContext.getSocketFactory();
        this.hostnameVerifier = x509HostnameVerifier;
        this.nameResolver = null;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sock = (SSLSocket)this.socketfactory.createSocket();
        this.prepareSocket(sock);
        return sock;
    }

    public Socket connectSocket(Socket socket, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sSLSocket;
        Socket socket2;
        if (inetSocketAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (httpParams == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Socket socket3 = socket2 = socket != null ? socket : this.socketfactory.createSocket();
        if (inetSocketAddress2 != null) {
            socket2.setReuseAddress(HttpConnectionParams.getSoReuseaddr(httpParams));
            socket2.bind(inetSocketAddress2);
        }
        int n = HttpConnectionParams.getConnectionTimeout(httpParams);
        int n2 = HttpConnectionParams.getSoTimeout(httpParams);
        try {
            socket2.setSoTimeout(n2);
            socket2.connect(inetSocketAddress, n);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new ConnectTimeoutException("Connect to " + inetSocketAddress + " timed out");
        }
        String string = inetSocketAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)inetSocketAddress).getHttpHost().getHostName() : inetSocketAddress.getHostName();
        if (socket2 instanceof SSLSocket) {
            sSLSocket = (SSLSocket)socket2;
        } else {
            int n3 = inetSocketAddress.getPort();
            sSLSocket = (SSLSocket)this.socketfactory.createSocket(socket2, string, n3, true);
            this.prepareSocket(sSLSocket);
        }
        if (this.hostnameVerifier != null) {
            try {
                this.hostnameVerifier.verify(string, sSLSocket);
            }
            catch (IOException iOException) {
                try {
                    sSLSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
        }
        return sSLSocket;
    }

    public boolean isSecure(Socket socket) throws IllegalArgumentException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (!(socket instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory");
        }
        if (socket.isClosed()) {
            throw new IllegalArgumentException("Socket is closed");
        }
        return true;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, true);
        this.prepareSocket(sslSocket);
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(host, sslSocket);
        }
        return sslSocket;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, autoClose);
        this.prepareSocket(sslSocket);
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(host, sslSocket);
        }
        return sslSocket;
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }
}

