/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time;

import com.amazonaws.org.joda.convert.ToString;
import com.amazonaws.org.joda.time.Chronology;
import com.amazonaws.org.joda.time.DateTimeField;
import com.amazonaws.org.joda.time.DateTimeFieldType;
import com.amazonaws.org.joda.time.DateTimeZone;
import com.amazonaws.org.joda.time.ReadWritableDateTime;
import com.amazonaws.org.joda.time.base.BaseDateTime;
import com.amazonaws.org.joda.time.field.AbstractReadableInstantFieldProperty;
import com.amazonaws.org.joda.time.format.ISODateTimeFormat;
import java.io.Serializable;

public class MutableDateTime
extends BaseDateTime
implements ReadWritableDateTime,
Serializable,
Cloneable {
    private DateTimeField iRoundingField;
    private int iRoundingMode;

    public MutableDateTime() {
    }

    public MutableDateTime(long l, DateTimeZone dateTimeZone) {
        super(l, dateTimeZone);
    }

    public MutableDateTime(long l, Chronology chronology) {
        super(l, chronology);
    }

    public void setMillis(long l) {
        switch (this.iRoundingMode) {
            case 0: {
                break;
            }
            case 1: {
                l = this.iRoundingField.roundFloor(l);
                break;
            }
            case 2: {
                l = this.iRoundingField.roundCeiling(l);
                break;
            }
            case 3: {
                l = this.iRoundingField.roundHalfFloor(l);
                break;
            }
            case 4: {
                l = this.iRoundingField.roundHalfCeiling(l);
                break;
            }
            case 5: {
                l = this.iRoundingField.roundHalfEven(l);
            }
        }
        super.setMillis(l);
    }

    public Property property(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        DateTimeField dateTimeField = dateTimeFieldType.getField(this.getChronology());
        if (!dateTimeField.isSupported()) {
            throw new IllegalArgumentException("Field '" + dateTimeFieldType + "' is not supported");
        }
        return new Property(this, dateTimeField);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone error");
        }
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private MutableDateTime iInstant;
        private DateTimeField iField;

        Property(MutableDateTime mutableDateTime, DateTimeField dateTimeField) {
            this.iInstant = mutableDateTime;
            this.iField = dateTimeField;
        }

        public DateTimeField getField() {
            return this.iField;
        }

        protected long getMillis() {
            return this.iInstant.getMillis();
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public MutableDateTime set(int n) {
            this.iInstant.setMillis(this.getField().set(this.iInstant.getMillis(), n));
            return this.iInstant;
        }
    }
}

