/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.org.joda.time.field;

import com.amazonaws.org.joda.time.DurationField;
import com.amazonaws.org.joda.time.DurationFieldType;
import com.amazonaws.org.joda.time.field.DecoratedDurationField;
import com.amazonaws.org.joda.time.field.FieldUtils;

public class ScaledDurationField
extends DecoratedDurationField {
    private final int iScalar;

    public ScaledDurationField(DurationField durationField, DurationFieldType durationFieldType, int n) {
        super(durationField, durationFieldType);
        if (n == 0 || n == 1) {
            throw new IllegalArgumentException("The scalar must not be 0 or 1");
        }
        this.iScalar = n;
    }

    public long add(long l, int n) {
        long l2 = (long)n * (long)this.iScalar;
        return this.getWrappedField().add(l, l2);
    }

    public long add(long l, long l2) {
        long l3 = FieldUtils.safeMultiply(l2, this.iScalar);
        return this.getWrappedField().add(l, l3);
    }

    public long getUnitMillis() {
        return this.getWrappedField().getUnitMillis() * (long)this.iScalar;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ScaledDurationField) {
            ScaledDurationField scaledDurationField = (ScaledDurationField)object;
            return this.getWrappedField().equals(scaledDurationField.getWrappedField()) && this.getType() == scaledDurationField.getType() && this.iScalar == scaledDurationField.iScalar;
        }
        return false;
    }

    public int hashCode() {
        long l = this.iScalar;
        int n = (int)(l ^ l >>> 32);
        n += this.getType().hashCode();
        return n += this.getWrappedField().hashCode();
    }
}

