/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnlinkIdentityRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String identityId;
    private Map<String, String> logins;
    private ListWithAutoConstructFlag<String> loginsToRemove;

    public String getIdentityId() {
        return this.identityId;
    }

    public void setIdentityId(String string) {
        this.identityId = string;
    }

    public UnlinkIdentityRequest withIdentityId(String string) {
        this.identityId = string;
        return this;
    }

    public Map<String, String> getLogins() {
        if (this.logins == null) {
            this.logins = new HashMap<String, String>();
        }
        return this.logins;
    }

    public void setLogins(Map<String, String> map) {
        this.logins = map;
    }

    public UnlinkIdentityRequest withLogins(Map<String, String> map) {
        this.setLogins(map);
        return this;
    }

    public UnlinkIdentityRequest addLoginsEntry(String string, String string2) {
        if (null == this.logins) {
            this.logins = new HashMap<String, String>();
        }
        if (this.logins.containsKey(string)) {
            throw new IllegalArgumentException("Duplicated keys (" + string.toString() + ") are provided.");
        }
        this.logins.put(string, string2);
        return this;
    }

    public UnlinkIdentityRequest clearLoginsEntries() {
        this.logins = null;
        return this;
    }

    public List<String> getLoginsToRemove() {
        if (this.loginsToRemove == null) {
            this.loginsToRemove = new ListWithAutoConstructFlag();
            this.loginsToRemove.setAutoConstruct(true);
        }
        return this.loginsToRemove;
    }

    public void setLoginsToRemove(Collection<String> collection) {
        if (collection == null) {
            this.loginsToRemove = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.loginsToRemove = listWithAutoConstructFlag;
    }

    public UnlinkIdentityRequest withLoginsToRemove(String ... stringArray) {
        if (this.getLoginsToRemove() == null) {
            this.setLoginsToRemove(new ArrayList<String>(stringArray.length));
        }
        for (String string : stringArray) {
            this.getLoginsToRemove().add(string);
        }
        return this;
    }

    public UnlinkIdentityRequest withLoginsToRemove(Collection<String> collection) {
        if (collection == null) {
            this.loginsToRemove = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.loginsToRemove = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getIdentityId() != null) {
            stringBuilder.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getLogins() != null) {
            stringBuilder.append("Logins: " + this.getLogins() + ",");
        }
        if (this.getLoginsToRemove() != null) {
            stringBuilder.append("LoginsToRemove: " + this.getLoginsToRemove());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        n = 31 * n + (this.getLogins() == null ? 0 : ((Object)this.getLogins()).hashCode());
        n = 31 * n + (this.getLoginsToRemove() == null ? 0 : ((Object)this.getLoginsToRemove()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UnlinkIdentityRequest)) {
            return false;
        }
        UnlinkIdentityRequest unlinkIdentityRequest = (UnlinkIdentityRequest)object;
        if (unlinkIdentityRequest.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (unlinkIdentityRequest.getIdentityId() != null && !unlinkIdentityRequest.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (unlinkIdentityRequest.getLogins() == null ^ this.getLogins() == null) {
            return false;
        }
        if (unlinkIdentityRequest.getLogins() != null && !((Object)unlinkIdentityRequest.getLogins()).equals(this.getLogins())) {
            return false;
        }
        if (unlinkIdentityRequest.getLoginsToRemove() == null ^ this.getLoginsToRemove() == null) {
            return false;
        }
        return unlinkIdentityRequest.getLoginsToRemove() == null || ((Object)unlinkIdentityRequest.getLoginsToRemove()).equals(this.getLoginsToRemove());
    }
}

