/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.HashMap;
import java.util.Map;

public class MapUnmarshaller<K, V>
implements Unmarshaller<Map<K, V>, JsonUnmarshallerContext> {
    private final Unmarshaller<K, JsonUnmarshallerContext> keyUnmarshaller;
    private final Unmarshaller<V, JsonUnmarshallerContext> valueUnmarshaller;

    public MapUnmarshaller(Unmarshaller<K, JsonUnmarshallerContext> unmarshaller, Unmarshaller<V, JsonUnmarshallerContext> unmarshaller2) {
        this.keyUnmarshaller = unmarshaller;
        this.valueUnmarshaller = unmarshaller2;
    }

    @Override
    public Map<K, V> unmarshall(JsonUnmarshallerContext jsonUnmarshallerContext) throws Exception {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        int n = jsonUnmarshallerContext.getCurrentDepth();
        if (jsonUnmarshallerContext.currentToken == JsonToken.VALUE_NULL) {
            return null;
        }
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonUnmarshallerContext.nextToken()) == null) {
                return hashMap;
            }
            if (jsonToken == JsonToken.FIELD_NAME) {
                K k = this.keyUnmarshaller.unmarshall(jsonUnmarshallerContext);
                jsonToken = jsonUnmarshallerContext.nextToken();
                V v = this.valueUnmarshaller.unmarshall(jsonUnmarshallerContext);
                hashMap.put(k, v);
                continue;
            }
            if ((jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) && jsonUnmarshallerContext.getCurrentDepth() <= n) break;
        }
        return hashMap;
    }
}

