/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.org.apache.http.HttpHost;
import com.amazonaws.org.apache.http.auth.AuthScope;
import com.amazonaws.org.apache.http.auth.NTCredentials;
import com.amazonaws.org.apache.http.client.methods.HttpGet;
import com.amazonaws.org.apache.http.client.utils.URLEncodedUtils;
import com.amazonaws.org.apache.http.impl.client.DefaultHttpClient;
import com.amazonaws.org.apache.http.message.BasicNameValuePair;
import com.amazonaws.org.apache.http.params.BasicHttpParams;
import com.amazonaws.org.apache.http.params.HttpConnectionParams;
import com.amazonaws.org.apache.http.params.HttpProtocolParams;
import com.amazonaws.util.HttpClientWrappingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern ENCODED_CHARACTERS_PATTERN;

    public static String urlEncode(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        try {
            String string2 = URLEncoder.encode(string, DEFAULT_ENCODING);
            Matcher matcher = ENCODED_CHARACTERS_PATTERN.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer(string2.length());
            while (matcher.find()) {
                String string3 = matcher.group(0);
                if ("+".equals(string3)) {
                    string3 = "%20";
                } else if ("*".equals(string3)) {
                    string3 = "%2A";
                } else if ("%7E".equals(string3)) {
                    string3 = "~";
                } else if (bl && "%2F".equals(string3)) {
                    string3 = "/";
                }
                matcher.appendReplacement(stringBuffer, string3);
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static boolean isUsingNonDefaultPort(URI uRI) {
        String string = uRI.getScheme().toLowerCase();
        int n = uRI.getPort();
        if (n <= 0) {
            return false;
        }
        if (string.equals("http") && n == 80) {
            return false;
        }
        return !string.equals("https") || n != 443;
    }

    public static boolean usePayloadForQueryParameters(Request<?> request) {
        boolean bl = HttpMethodName.POST.equals((Object)request.getHttpMethod());
        boolean bl2 = request.getContent() == null;
        return bl && bl2;
    }

    public static String encodeParameters(Request<?> request) {
        ArrayList<BasicNameValuePair> arrayList = null;
        if (request.getParameters().size() > 0) {
            arrayList = new ArrayList<BasicNameValuePair>(request.getParameters().size());
            for (Map.Entry entry : request.getParameters().entrySet()) {
                arrayList.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        Object object = null;
        if (arrayList != null) {
            object = URLEncodedUtils.format(arrayList, DEFAULT_ENCODING);
        }
        return object;
    }

    public static String appendUri(String string, String string2) {
        return HttpUtils.appendUri(string, string2, false);
    }

    public static String appendUri(String string, String string2, boolean bl) {
        String string3 = string;
        if (string2 != null && string2.length() > 0) {
            if (string2.startsWith("/")) {
                if (string3.endsWith("/")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
            } else if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            String string4 = HttpUtils.urlEncode(string2, true);
            if (bl) {
                string4 = string4.replace("//", "/%2F");
            }
            string3 = string3 + string4;
        } else if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        return string3;
    }

    public static InputStream fetchFile(URI uRI, ClientConfiguration clientConfiguration) throws IOException {
        Object object;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(basicHttpParams, HttpUtils.getUserAgent(clientConfiguration));
        HttpConnectionParams.setConnectionTimeout(basicHttpParams, HttpUtils.getConnectionTimeout(clientConfiguration));
        HttpConnectionParams.setSoTimeout(basicHttpParams, HttpUtils.getSocketTimeout(clientConfiguration));
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient(basicHttpParams);
        if (clientConfiguration != null) {
            object = clientConfiguration.getProxyHost();
            int n = clientConfiguration.getProxyPort();
            if (object != null && n > 0) {
                HttpHost httpHost = new HttpHost((String)object, n);
                defaultHttpClient.getParams().setParameter("http.route.default-proxy", httpHost);
                if (clientConfiguration.getProxyUsername() != null && clientConfiguration.getProxyPassword() != null) {
                    defaultHttpClient.getCredentialsProvider().setCredentials(new AuthScope((String)object, n), new NTCredentials(clientConfiguration.getProxyUsername(), clientConfiguration.getProxyPassword(), clientConfiguration.getProxyWorkstation(), clientConfiguration.getProxyDomain()));
                }
            }
        }
        if ((object = defaultHttpClient.execute(new HttpGet(uRI))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uRI + ": " + object);
        }
        return new HttpClientWrappingInputStream(defaultHttpClient, object.getEntity().getContent());
    }

    private static String getUserAgent(ClientConfiguration clientConfiguration) {
        String string = null;
        if (clientConfiguration != null) {
            string = clientConfiguration.getUserAgent();
        }
        if (string == null) {
            string = ClientConfiguration.DEFAULT_USER_AGENT;
        } else if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(string)) {
            string = string + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        return string;
    }

    private static int getConnectionTimeout(ClientConfiguration clientConfiguration) {
        if (clientConfiguration != null) {
            return clientConfiguration.getConnectionTimeout();
        }
        return 50000;
    }

    private static int getSocketTimeout(ClientConfiguration clientConfiguration) {
        if (clientConfiguration != null) {
            return clientConfiguration.getSocketTimeout();
        }
        return 50000;
    }

    static {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Pattern.quote("+")).append("|").append(Pattern.quote("*")).append("|").append(Pattern.quote("%7E")).append("|").append(Pattern.quote("%2F"));
        ENCODED_CHARACTERS_PATTERN = Pattern.compile(stringBuilder.toString());
    }
}

