/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.util.Base64;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;

public class StringUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static Integer toInteger(StringBuilder stringBuilder) {
        return Integer.parseInt(stringBuilder.toString());
    }

    public static String toString(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    public static Boolean toBoolean(StringBuilder stringBuilder) {
        return Boolean.getBoolean(stringBuilder.toString());
    }

    public static String fromInteger(Integer n) {
        return Integer.toString(n);
    }

    public static String fromLong(Long l) {
        return Long.toString(l);
    }

    public static String fromString(String string) {
        return string;
    }

    public static String fromBoolean(Boolean bl) {
        return Boolean.toString(bl);
    }

    public static String fromBigInteger(BigInteger bigInteger) {
        return bigInteger.toString();
    }

    public static String fromBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static BigInteger toBigInteger(String string) {
        return new BigInteger(string);
    }

    public static BigDecimal toBigDecimal(String string) {
        return new BigDecimal(string);
    }

    public static String fromFloat(Float f) {
        return Float.toString(f.floatValue());
    }

    public static String fromDate(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static String fromDouble(Double d) {
        return Double.toString(d);
    }

    public static String fromByte(Byte by) {
        return Byte.toString(by);
    }

    public static String fromByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return Base64.encodeAsString(byteBuffer.array());
        }
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return Base64.encodeAsString(byArray);
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string);
        int n = stringBuffer.indexOf(string2);
        while (n != -1) {
            stringBuffer = stringBuffer.replace(n, n + string2.length(), string3);
            n = stringBuffer.indexOf(string2);
        }
        return stringBuffer.toString();
    }

    public static String join(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

