/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.amazonaws.services.securitytoken.model.transform.PolicyDescriptorTypeStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleWithSAMLRequestMarshaller
implements Marshaller<Request<AssumeRoleWithSAMLRequest>, AssumeRoleWithSAMLRequest> {
    @Override
    public Request<AssumeRoleWithSAMLRequest> marshall(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        String prefix;
        if (assumeRoleWithSAMLRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(AssumeRoleWithSAMLRequest)");
        }
        DefaultRequest<AssumeRoleWithSAMLRequest> request = new DefaultRequest<AssumeRoleWithSAMLRequest>(assumeRoleWithSAMLRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        if (assumeRoleWithSAMLRequest.getRoleArn() != null) {
            prefix = "RoleArn";
            String roleArn = assumeRoleWithSAMLRequest.getRoleArn();
            request.addParameter(prefix, StringUtils.fromString(roleArn));
        }
        if (assumeRoleWithSAMLRequest.getPrincipalArn() != null) {
            prefix = "PrincipalArn";
            String principalArn = assumeRoleWithSAMLRequest.getPrincipalArn();
            request.addParameter(prefix, StringUtils.fromString(principalArn));
        }
        if (assumeRoleWithSAMLRequest.getSAMLAssertion() != null) {
            prefix = "SAMLAssertion";
            String sAMLAssertion = assumeRoleWithSAMLRequest.getSAMLAssertion();
            request.addParameter(prefix, StringUtils.fromString(sAMLAssertion));
        }
        if (assumeRoleWithSAMLRequest.getPolicyArns() != null) {
            prefix = "PolicyArns";
            List<PolicyDescriptorType> policyArns = assumeRoleWithSAMLRequest.getPolicyArns();
            int policyArnsIndex = 1;
            String policyArnsPrefix = prefix;
            for (PolicyDescriptorType policyArnsItem : policyArns) {
                prefix = policyArnsPrefix + ".member." + policyArnsIndex;
                if (policyArnsItem != null) {
                    PolicyDescriptorTypeStaxMarshaller.getInstance().marshall(policyArnsItem, request, prefix + ".");
                }
                ++policyArnsIndex;
            }
            prefix = policyArnsPrefix;
        }
        if (assumeRoleWithSAMLRequest.getPolicy() != null) {
            prefix = "Policy";
            String policy = assumeRoleWithSAMLRequest.getPolicy();
            request.addParameter(prefix, StringUtils.fromString(policy));
        }
        if (assumeRoleWithSAMLRequest.getDurationSeconds() != null) {
            prefix = "DurationSeconds";
            Integer durationSeconds = assumeRoleWithSAMLRequest.getDurationSeconds();
            request.addParameter(prefix, StringUtils.fromInteger(durationSeconds));
        }
        return request;
    }
}

