/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.kms.model.EncryptionAlgorithmSpec;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReEncryptRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ByteBuffer ciphertextBlob;
    private Map<String, String> sourceEncryptionContext = new HashMap<String, String>();
    private String sourceKeyId;
    private String destinationKeyId;
    private Map<String, String> destinationEncryptionContext = new HashMap<String, String>();
    private String sourceEncryptionAlgorithm;
    private String destinationEncryptionAlgorithm;
    private List<String> grantTokens = new ArrayList<String>();

    public ByteBuffer getCiphertextBlob() {
        return this.ciphertextBlob;
    }

    public void setCiphertextBlob(ByteBuffer ciphertextBlob) {
        this.ciphertextBlob = ciphertextBlob;
    }

    public ReEncryptRequest withCiphertextBlob(ByteBuffer ciphertextBlob) {
        this.ciphertextBlob = ciphertextBlob;
        return this;
    }

    public Map<String, String> getSourceEncryptionContext() {
        return this.sourceEncryptionContext;
    }

    public void setSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
        this.sourceEncryptionContext = sourceEncryptionContext;
    }

    public ReEncryptRequest withSourceEncryptionContext(Map<String, String> sourceEncryptionContext) {
        this.sourceEncryptionContext = sourceEncryptionContext;
        return this;
    }

    public ReEncryptRequest addSourceEncryptionContextEntry(String key, String value) {
        if (null == this.sourceEncryptionContext) {
            this.sourceEncryptionContext = new HashMap<String, String>();
        }
        if (this.sourceEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.sourceEncryptionContext.put(key, value);
        return this;
    }

    public ReEncryptRequest clearSourceEncryptionContextEntries() {
        this.sourceEncryptionContext = null;
        return this;
    }

    public String getSourceKeyId() {
        return this.sourceKeyId;
    }

    public void setSourceKeyId(String sourceKeyId) {
        this.sourceKeyId = sourceKeyId;
    }

    public ReEncryptRequest withSourceKeyId(String sourceKeyId) {
        this.sourceKeyId = sourceKeyId;
        return this;
    }

    public String getDestinationKeyId() {
        return this.destinationKeyId;
    }

    public void setDestinationKeyId(String destinationKeyId) {
        this.destinationKeyId = destinationKeyId;
    }

    public ReEncryptRequest withDestinationKeyId(String destinationKeyId) {
        this.destinationKeyId = destinationKeyId;
        return this;
    }

    public Map<String, String> getDestinationEncryptionContext() {
        return this.destinationEncryptionContext;
    }

    public void setDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
        this.destinationEncryptionContext = destinationEncryptionContext;
    }

    public ReEncryptRequest withDestinationEncryptionContext(Map<String, String> destinationEncryptionContext) {
        this.destinationEncryptionContext = destinationEncryptionContext;
        return this;
    }

    public ReEncryptRequest addDestinationEncryptionContextEntry(String key, String value) {
        if (null == this.destinationEncryptionContext) {
            this.destinationEncryptionContext = new HashMap<String, String>();
        }
        if (this.destinationEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.destinationEncryptionContext.put(key, value);
        return this;
    }

    public ReEncryptRequest clearDestinationEncryptionContextEntries() {
        this.destinationEncryptionContext = null;
        return this;
    }

    public String getSourceEncryptionAlgorithm() {
        return this.sourceEncryptionAlgorithm;
    }

    public void setSourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
        this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
    }

    public ReEncryptRequest withSourceEncryptionAlgorithm(String sourceEncryptionAlgorithm) {
        this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm;
        return this;
    }

    public void setSourceEncryptionAlgorithm(EncryptionAlgorithmSpec sourceEncryptionAlgorithm) {
        this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm.toString();
    }

    public ReEncryptRequest withSourceEncryptionAlgorithm(EncryptionAlgorithmSpec sourceEncryptionAlgorithm) {
        this.sourceEncryptionAlgorithm = sourceEncryptionAlgorithm.toString();
        return this;
    }

    public String getDestinationEncryptionAlgorithm() {
        return this.destinationEncryptionAlgorithm;
    }

    public void setDestinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
        this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
    }

    public ReEncryptRequest withDestinationEncryptionAlgorithm(String destinationEncryptionAlgorithm) {
        this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm;
        return this;
    }

    public void setDestinationEncryptionAlgorithm(EncryptionAlgorithmSpec destinationEncryptionAlgorithm) {
        this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm.toString();
    }

    public ReEncryptRequest withDestinationEncryptionAlgorithm(EncryptionAlgorithmSpec destinationEncryptionAlgorithm) {
        this.destinationEncryptionAlgorithm = destinationEncryptionAlgorithm.toString();
        return this;
    }

    public List<String> getGrantTokens() {
        return this.grantTokens;
    }

    public void setGrantTokens(Collection<String> grantTokens) {
        if (grantTokens == null) {
            this.grantTokens = null;
            return;
        }
        this.grantTokens = new ArrayList<String>(grantTokens);
    }

    public ReEncryptRequest withGrantTokens(String ... grantTokens) {
        if (this.getGrantTokens() == null) {
            this.grantTokens = new ArrayList<String>(grantTokens.length);
        }
        for (String value : grantTokens) {
            this.grantTokens.add(value);
        }
        return this;
    }

    public ReEncryptRequest withGrantTokens(Collection<String> grantTokens) {
        this.setGrantTokens(grantTokens);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCiphertextBlob() != null) {
            sb.append("CiphertextBlob: " + this.getCiphertextBlob() + ",");
        }
        if (this.getSourceEncryptionContext() != null) {
            sb.append("SourceEncryptionContext: " + this.getSourceEncryptionContext() + ",");
        }
        if (this.getSourceKeyId() != null) {
            sb.append("SourceKeyId: " + this.getSourceKeyId() + ",");
        }
        if (this.getDestinationKeyId() != null) {
            sb.append("DestinationKeyId: " + this.getDestinationKeyId() + ",");
        }
        if (this.getDestinationEncryptionContext() != null) {
            sb.append("DestinationEncryptionContext: " + this.getDestinationEncryptionContext() + ",");
        }
        if (this.getSourceEncryptionAlgorithm() != null) {
            sb.append("SourceEncryptionAlgorithm: " + this.getSourceEncryptionAlgorithm() + ",");
        }
        if (this.getDestinationEncryptionAlgorithm() != null) {
            sb.append("DestinationEncryptionAlgorithm: " + this.getDestinationEncryptionAlgorithm() + ",");
        }
        if (this.getGrantTokens() != null) {
            sb.append("GrantTokens: " + this.getGrantTokens());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCiphertextBlob() == null ? 0 : this.getCiphertextBlob().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEncryptionContext() == null ? 0 : this.getSourceEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getSourceKeyId() == null ? 0 : this.getSourceKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationKeyId() == null ? 0 : this.getDestinationKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationEncryptionContext() == null ? 0 : this.getDestinationEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEncryptionAlgorithm() == null ? 0 : this.getSourceEncryptionAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationEncryptionAlgorithm() == null ? 0 : this.getDestinationEncryptionAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.getGrantTokens() == null ? 0 : this.getGrantTokens().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReEncryptRequest)) {
            return false;
        }
        ReEncryptRequest other = (ReEncryptRequest)obj;
        if (other.getCiphertextBlob() == null ^ this.getCiphertextBlob() == null) {
            return false;
        }
        if (other.getCiphertextBlob() != null && !other.getCiphertextBlob().equals(this.getCiphertextBlob())) {
            return false;
        }
        if (other.getSourceEncryptionContext() == null ^ this.getSourceEncryptionContext() == null) {
            return false;
        }
        if (other.getSourceEncryptionContext() != null && !other.getSourceEncryptionContext().equals(this.getSourceEncryptionContext())) {
            return false;
        }
        if (other.getSourceKeyId() == null ^ this.getSourceKeyId() == null) {
            return false;
        }
        if (other.getSourceKeyId() != null && !other.getSourceKeyId().equals(this.getSourceKeyId())) {
            return false;
        }
        if (other.getDestinationKeyId() == null ^ this.getDestinationKeyId() == null) {
            return false;
        }
        if (other.getDestinationKeyId() != null && !other.getDestinationKeyId().equals(this.getDestinationKeyId())) {
            return false;
        }
        if (other.getDestinationEncryptionContext() == null ^ this.getDestinationEncryptionContext() == null) {
            return false;
        }
        if (other.getDestinationEncryptionContext() != null && !other.getDestinationEncryptionContext().equals(this.getDestinationEncryptionContext())) {
            return false;
        }
        if (other.getSourceEncryptionAlgorithm() == null ^ this.getSourceEncryptionAlgorithm() == null) {
            return false;
        }
        if (other.getSourceEncryptionAlgorithm() != null && !other.getSourceEncryptionAlgorithm().equals(this.getSourceEncryptionAlgorithm())) {
            return false;
        }
        if (other.getDestinationEncryptionAlgorithm() == null ^ this.getDestinationEncryptionAlgorithm() == null) {
            return false;
        }
        if (other.getDestinationEncryptionAlgorithm() != null && !other.getDestinationEncryptionAlgorithm().equals(this.getDestinationEncryptionAlgorithm())) {
            return false;
        }
        if (other.getGrantTokens() == null ^ this.getGrantTokens() == null) {
            return false;
        }
        return other.getGrantTokens() == null || other.getGrantTokens().equals(this.getGrantTokens());
    }
}

